<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output
	method="xml"
	indent="no"
	encoding="utf-8"/>


	

<xsl:template match="//xbdict">
<!--?xml version="1.0" encoding="utf-8" standalone="no"? -->
<!--?xml-stylesheet type="text/css" href="eng-pol.css"? -->

<xsl:text disable-output-escaping="yes">
&lt;!DOCTYPE TEI PUBLIC "-//TEI P5//DTD Main Document Type//EN" "http://www.tei-c.org/release/xml/tei/schema/dtd/tei.dtd" [
	&lt;!ENTITY % TEI.XML          "INCLUDE">
	&lt;!ENTITY % TEI.dictionaries "INCLUDE"> 
	]>
</xsl:text>
	
<TEI>	
  
<teiHeader>
  <fileDesc>
    <titleStmt>
      <title>Skonwertowany słownik SalPiotr</title>
      <respStmt>
	<resp>opracowali</resp> <name>Adam Mazur i Maciej Wojciechowski</name>
      </respStmt>
    </titleStmt>
    <publicationStmt>
      <availability>
	Dostępny na licencji <ref target="http://www.gnu.org.pl/text/licencja-gnu.html"><abbr title="GNU General Public License">GNU GPL</abbr></ref>
      </availability>
    </publicationStmt>
	<sourceDesc>
	<bibl></bibl>
    </sourceDesc>
  </fileDesc>
</teiHeader>
    
<text>
  <body>
	<xsl:apply-templates select="//entry"/>
	</body>
	</text>
</TEI>
</xsl:template>



<xsl:template match="entry">
	<entry>

	<!-- Kazde entry powinno miec headword -->
	<xsl:choose>
		<xsl:when test="./headword">
			<form>
				<!-- tei:
				 -  <form>
				 -    <orth>pisownia - obowiazkowo</orth>
				 -    <pron>wymowa - opcjonalnie, chyba zawsze jedno</pron>
				 -  </form>
				 -->
				
				<xsl:apply-templates select="./headword/spl"/>
				
				<xsl:apply-templates select="./hwinfo/pronunciation"/>
			
			</form>

			<xsl:if test="./hwinfo/pos">
				<gramGrp>
					<pos><xsl:value-of select="./hwinfo/pos"/></pos>
				</gramGrp>
			</xsl:if>

			<xsl:if test="(./headword/lang) or (./hwinfo/label)">
				<etym>
					<xsl:if test="./headword/lang">
						<lang><xsl:value-of select="./headword/lang"/></lang>
					</xsl:if>
					<xsl:if test="./hwinfo/label">
						<lbl><xsl:value-of select="./hwinfo/label"/></lbl>
					</xsl:if>
				</etym>
			</xsl:if>

			<xsl:for-each select="./hwinfo/variant">
				<xsl:call-template name="variant_as_oVar"/>
			</xsl:for-each>

			<xsl:for-each select="./hwinfo/xr/xrentry">
				<xr><xsl:value-of select="."/></xr>
			</xsl:for-each>
			
		</xsl:when>
		<xsl:otherwise>
DUPA (1): nie ma <xsl:call-template name="print-path"/>
		</xsl:otherwise>
	</xsl:choose>
	

	<!-- rozwalamy syntaktiki -->
	<xsl:variable name="syn_count" select="count(./syntactic)"/>
	<xsl:for-each select="./syntactic">
		<xsl:call-template name="go_with_syntactic">
			<xsl:with-param name="syn_pos" select="position()"/>
			<xsl:with-param name="syn_count" select="$syn_count"/>
			<xsl:with-param name="syn_node" select="."/>
		</xsl:call-template>
	</xsl:for-each>
		
	</entry>


	<!-- sprawdzamy czy wszystko zuzylismy -->
	
	<xsl:for-each select="./headword/*">	
		<xsl:choose>
			<xsl:when test="name(.) = 'spl'"></xsl:when>
			<xsl:when test="name(.) = 'lang'"></xsl:when>
			<xsl:otherwise>
DUPA (2): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	<xsl:for-each select="./hwinfo/*">
		<xsl:choose>
			<xsl:when test="name(.) = 'pos'"></xsl:when>
			<xsl:when test="name(.) = 'label'"></xsl:when>
			<xsl:when test="(name(.) = 'variant') and (./spl)"></xsl:when>
			<xsl:when test="(name(.) = 'xr') and (./xrentry)"></xsl:when>
			<xsl:when test="name(.) = 'pronunciation'"></xsl:when>
			<xsl:otherwise>
DUPA (3): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	
</xsl:template>




<xsl:template name="go_with_syntactic">
	<xsl:param name="syn_node"/>
	<xsl:param name="syn_count"/>
	<xsl:param name="syn_pos"/>

	<sense>
		<xsl:if test="$syn_count != 1">
			<xsl:attribute name="n"><xsl:value-of select="$syn_pos"/></xsl:attribute>
		</xsl:if>

		<xsl:apply-templates select="./senseinfo"/>
	
		<xsl:apply-templates select="./semantic"/>
	</sense>

	
	<!-- sprawdzamy czy wszystko zuzylismy -->
	<xsl:for-each select="./*">
		<xsl:choose>
			<xsl:when test="name(.) = 'senseinfo'"></xsl:when>
			<xsl:when test="name(.) = 'semantic'"></xsl:when>
			<xsl:otherwise>
DUPA (8): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>



<xsl:template match="senseinfo">
	<xsl:if test="./pos">
		<gramGrp>
			<pos>
				<xsl:value-of select="./pos"/>
			</pos>
		</gramGrp>
	</xsl:if>

	<xsl:for-each select="./variant">
		<xsl:call-template name="variant_as_xRef">
			<xsl:with-param name="xrtype" value="'cf'"/> <!-- type="cf" -> related or similar term -->
		</xsl:call-template>
	</xsl:for-each>

	<xsl:for-each select="./label">
		<xr type="etym"><xsl:value-of select="."/></xr>
	</xsl:for-each>
	
	<xsl:for-each select="./trans">
		<trans>
			<tr><xsl:value-of select="."/></tr>
			<xsl:for-each select="../indicator">            <!-- tylko dla trans... odwolanie do tego node'a byc -->
				<colloc><xsl:value-of select="."/></colloc> <!-- rowniez z poziomu subinfo/trans (to glupie, ale -->
			</xsl:for-each>                                 <!-- nie wiem jak to inaczej sprytnie zakodowac)     -->
		
			<xsl:apply-templates select="./pronunciation"/>
		</trans>
	</xsl:for-each>

	<xsl:for-each select="./xr/xrentry">
		<xr><xsl:value-of select="."/></xr>
	</xsl:for-each>

	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
		<xsl:choose>
			<xsl:when test="name(.) = 'pos'"></xsl:when>
			<xsl:when test="name(.) = 'variant'"></xsl:when>
			<xsl:when test="name(.) = 'label'"></xsl:when>
			<xsl:when test="name(.) = 'trans'"></xsl:when>
			<xsl:when test="name(.) = 'indicator'"></xsl:when> <!-- o ile istnieje trans, lub ../subsense/trans -->
			<xsl:when test="name(.) = 'pronunciation'"></xsl:when>
			<xsl:when test="(name(.) = 'xr') and (./xrentry)"></xsl:when>
			<xsl:otherwise>
DUPA (4): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>



<xsl:template match="semantic">
	<sense>
		<xsl:if test="./subsense/idiom">
			<xsl:attribute name="type">idiom</xsl:attribute>
		</xsl:if>
		<xsl:apply-templates select="senseinfo"/>
		<xsl:apply-templates select="subsense"/>
	</sense>
	
	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
		<xsl:choose>
			<xsl:when test="name(.) = 'senseinfo'"></xsl:when>
			<xsl:when test="name(.) = 'subsense'"></xsl:when>
			<xsl:otherwise>
DUPA (5): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>



<xsl:template match="subsense">
		<xsl:apply-templates match="./trans and ./gloss and ./preposition and ./idiom and ./idarex and ./example"/>

	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
		<xsl:choose>
			<xsl:when test="name(.) = 'trans'"></xsl:when>
			<xsl:when test="name(.) = 'idiom'"></xsl:when>
			<xsl:when test="name(.) = 'idarex'"></xsl:when>
			<xsl:when test="name(.) = 'gloss'"></xsl:when>
			<xsl:when test="name(.) = 'example'"></xsl:when>
			<xsl:when test="name(.) = 'preposition'"></xsl:when>
			<xsl:otherwise>
DUPA (7): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>



<xsl:template match="example">
		<dicteg><q><xsl:value-of select="."/></q></dicteg>
</xsl:template>



<xsl:template match="idiom">
	<usg type="idiom"><xsl:value-of select="."/></usg>
</xsl:template>



<!--
 - IDAREX - czyli wyrazenia regularne dla idiomow
 - Niestety w TEI chyba nie ma dla tego miejsca.
 - Dlatego wkladamy to w <note type="idarex">...</note>
 -->
<xsl:template match="idarex">
	<note type='idarex'><xsl:value-of select="."/></note>
</xsl:template>




<xsl:template match="trans">
	<trans>
		<tr><xsl:value-of select="text()"/></tr>
		<xsl:for-each select="../../senseinfo/indicator">
			<colloc><xsl:value-of select="."/></colloc>
		</xsl:for-each>
		<xsl:for-each select="./i">
			<colloc><xsl:value-of select="."/></colloc>
		</xsl:for-each>
	</trans>
	
	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
		<xsl:if test="name() != 'i'">
DUPA (A): nie zajelismy sie <xsl:call-template name="print-path"/>
		</xsl:if>
	</xsl:for-each>
</xsl:template>




<xsl:template match="gloss">
	<trans>
		<def><xsl:value-of select="."/></def>
	</trans>
	
	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
DUPA (B): nie zajelismy sie <xsl:call-template name="print-path"/>
	</xsl:for-each>
</xsl:template>



<xsl:template match="preposition">
	<xsl:variable name="preps" select="./*"/>
	<trans>
	<xsl:for-each select="$preps">
		<xsl:variable name="prevpos" select="position() - 1"/>
		<xsl:choose>
			
			<!-- najpierw test czy w ogole nie pomijamy jakichs node'ow -->
			<xsl:when test="(name(.) != 'prepsource') and (name() != 'preptarget')">
DUPA (C): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:when>
		
			<!-- jesli poprzedni to preptarget, a biezacy prepsource - zamknij <trans> i otworz nowe -->
			<xsl:when test="(name(.) = 'prepsource') and (name($preps[$prevpos]) = 'preptarget')">
				<xsl:text disable-output-escaping="yes">&lt;/trans&gt;&lt;trans&gt;</xsl:text>
				<xsl:apply-templates select="."/>
			</xsl:when>
			
			<xsl:otherwise>
				<xsl:apply-templates select="."/>
			</xsl:otherwise>
			
		</xsl:choose>
	</xsl:for-each>
	</trans>
</xsl:template>



<xsl:template match="prepsource">
	<colloc type="prep"><xsl:value-of select="."/></colloc>
</xsl:template>
	


<xsl:template match="preptarget">
	<tr><xsl:value-of select="."/></tr>
</xsl:template>
	


<xsl:template match="pronunciation">
	<pron><xsl:value-of select="./phonetic"/></pron>

	<!-- sprawdzamy czego nie zjedlismy -->
	<xsl:for-each select="./*">
		<xsl:choose>
			<xsl:when test="name(.) = 'phonetic'"></xsl:when>
			<xsl:otherwise>
DUPA (9): nie zajelismy sie <xsl:call-template name="print-path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>




<xsl:template match="spl">
	<orth><xsl:value-of select="."/></orth>
</xsl:template>




<xsl:template name="variant_as_oVar">
	<dicteg>
	<xsl:for-each select="./spl">
		<q><oVar><xsl:value-of select="."/></oVar></q>
	</xsl:for-each>
	</dicteg>
</xsl:template>




<xsl:template name="variant_as_xRef">
<xsl:param name="xrtype"/>
	<xr>
	<xsl:if test="$xrtype">
		<xsl:attribute name="type"><xsl:value-of select="$xrtype"/></xsl:attribute>
	</xsl:if>
	<xsl:for-each select="./spl">
		<q><oVar><xsl:value-of select="."/></oVar></q>
	</xsl:for-each>
	</xr>
</xsl:template>




<!--
  - sluzy jedynie pomocy przy debugowaniu:
  - drukuje sciezke nazw node'ow od roota do biezacego
  -->
<xsl:template name="print-path">
<xsl:param name="node" select="."/>
	<xsl:if test="$node/..">
		<xsl:call-template name="print-path">
			<xsl:with-param name="node" select="$node/.."/>
		</xsl:call-template>
		<xsl:text>/</xsl:text>
	</xsl:if>
	<xsl:value-of select="name($node)"/>
	<xsl:if test="$node = .">
		<xsl:text>
		</xsl:text>
	</xsl:if>
</xsl:template>



</xsl:stylesheet>

