
#include <math.h>
#include <stdio.h>
#include <ctype.h>
#define MAXFNAME 15
#define VOID int
#define TRUE 1
#define FALSE 0
#define MAXFORMLEN 60
#define MAXFORMNUM 100
  int    inc, inchar ; /* zmienna uzywana do ident. end-of-file */ 
  int KTORY ; /* zmienna okreslajaca kolejny przebieg laczenia */
  int NUMER ;
  int JAKIE ;
  int z1  ; /* zmienna pomocnicza */
  
  FILE   *Infile1 ;
  FILE   *Infile2 ;
  FILE   *Outfile ;

  typedef struct ft1 {
             int    frekw ;
             char   forma[MAXFORMLEN] ;
	       int    kropka ;
		 int    plus ;
	          int    kod ;
     				    } FORMTYPE1 ;

  typedef struct wt1 {
             int       ileform ;
          FORMTYPE1 haslo ;
          FORMTYPE1 forma[ 1 /*MAXFORMNUM*/  ] ;
	          int       ilosc ;
				          } WORDTYPE1 ;

  typedef struct ft2 {
             int    frekw[6] ;    /* 6 miejsc */
             char   forma[MAXFORMLEN] ;
	       int    kropka ;
		 int    plus ;
	       int    kod ;
	    				    } FORMTYPE2 ;

  typedef struct wt2 {
             int       ileform ;
				 int       numer ;
				 float     D, U ;
             FORMTYPE2 haslo ;
	          FORMTYPE2 forma[MAXFORMNUM] ;
	                   } WORDTYPE2 ;


  typedef struct wt3 {
             int       ileform ;
				 int       numer, mowa ;
				 float     D, U ;
             FORMTYPE2 haslo ;
	          FORMTYPE2 forma[ MAXFORMNUM ] ;
	                   } WORDTYPE3 ;

main(argc, argv)
int argc ;
char *argv[] ;

     {      /* main program */
  WORDTYPE1  slowo1 ;
  FORMTYPE1  slowo ;

  WORDTYPE2  slowo2, slowo3, slowo5 ;
  WORDTYPE3  slowo4 ;
   
  char   filename[MAXFNAME] ;
  int    eoln ;
  int    k, i ;
  int    noeof11, noeof21, noeof12, noeof23 ;
  
  noeof11 = TRUE ;
  noeof21 = TRUE ;
  noeof12 = TRUE ;
  noeof23 = TRUE ; 

  NUMER = 0 ;
  if ( argc == 1 )
     {   fprintf(stdout, "\nProgram nalezy wywolywac z jednym parametrem") ;
	      fprintf(stdout, "\nliczbowym. Znaczenie liczb jest nastepujace:") ;
			fprintf(stdout, "\n   1 - do@laczanie pierwszego tomu (styl c),") ;
			fprintf(stdout, "\n   2 - do@laczanie drugiego tomu   (styl b),") ;
			fprintf(stdout, "\n   3 - do@laczanie trzeciego tomu  (styl a),") ;
			fprintf(stdout, "\n   4 - do@laczanie czwartego tomu  (styl d),") ;
			fprintf(stdout, "\n   5 - do@laczanie piatego tomu    (styl e),") ;
			fprintf(stdout, "\n       oraz obliczanie D i U,") ;
			fprintf(stdout, "\n   6 - odcinanie niskich frekwencji,") ;
			fprintf(stdout, "\n   7 - usuwanie imion w@lasnych,") ;
			fprintf(stdout, "\n   8 - przygotowanie danych dla TEX'a") ;
			fprintf(stdout, "\n   9 - laczenie wskazanych hasel,") ;
			fprintf(stdout, "\n  10 - jezyk mowiony,") ;
			fprintf(stdout, "\n  11 - lista hase@l.") ;
			exit(0) ;
		}

  if ( argc != 2 )
     {   fprintf(stderr, "Zla liczba argumentow wywolania. \n") ;
         exit(0) ; }
	 
  KTORY = atoi(argv[1]) ;
  if ((KTORY < 1) || (KTORY > 11))
     {   fprintf(stderr, "Zla wartosc parametru. \n") ;
         exit(0) ; }
	 
  if ( KTORY == 6 )
   { printf("Ze slownika wycinane sa rekordy \n" ) ;
	 printf("o frekwencji mniejszej niz :") ; 
   	fgets(filename, MAXFNAME, stdin) ;
		eoln = stripnewlines(filename) ;
		JAKIE = atoi(filename) ;
  	 }
  if ( KTORY == 7 )
    printf("Usuwanie imion wl. i skrotowcow.\n") ;
	 
  if ( KTORY == 8 )
    printf("Przygotowanie danych dla TEX'a.\n") ;
	 	 
  if ( KTORY == 9 )
    printf("Interakcyjne laczenie wskazanych hasel.\n") ;	   
   	
  if ( KTORY == 10 )
    printf("Obrobka jezyka mowionego.\n") ;
   
  if ( KTORY == 11 )
    printf("Listy hase@l.\n") ;  
 if ( KTORY < 6 || KTORY == 10 )  
  {if (KTORY != 10) 
         printf("\fDo slownika dodawany jest zbior %d .\n", KTORY) ;
  	      printf("Nazwa pierwszego zbioru wejsciowego: ") ;
         fgets(filename, MAXFNAME, stdin) ;
         eoln = stripnewlines(filename) ;
	
	
	/* kontrola korelacji KTORY i nazwy zbioru wejsciowego */
	if ( KTORY == 1 && filename[0] != 'c' ) 
	   {  fprintf(stderr, "Spodziewalem sie stylu C") ; exit(0) ;	}

	if ( KTORY == 2 && filename[0] != 'b' ) 
	   {  fprintf(stderr, "Spodziewalem sie stylu B") ; exit(0) ;	}
		
	if ( KTORY == 3 && filename[0] != 'a' ) 
	   {  fprintf(stderr, "Spodziewalem sie stylu A") ; exit(0) ;	}
		
	if ( KTORY == 4 && filename[0] != 'd' ) 
	   {  fprintf(stderr, "Spodziewalem sie stylu D") ; exit(0) ;	}
		
	if ( KTORY == 5 && filename[0] != 'e' ) 
	   {  fprintf(stderr, "Spodziewalem sie stylu E") ; exit(0) ;	}

   if (( Infile1 = fopen(filename, "r")) == 0 )
      {
      fprintf(stderr, "Nie moge otworzyc zbioru %s dla czytania.\n",filename) ;
      exit(0) ;
      }
	}


if (KTORY != 1)
  {
   if ( KTORY  < 6 || KTORY == 10 )	
	  printf("Nazwa drugiego zbioru wejsciowego: ") ;
       else
		   printf("Nazwa zbioru wejsciowego: ") ;
	
	fgets(filename, MAXFNAME, stdin) ;
   eoln =  stripnewlines(filename) ;

   if (( Infile2 = fopen(filename, "r")) == 0 )
      {
	  fprintf(stderr, "Nie moge otworzyc zbioru %s dla czytania.\n",filename) ;
      exit(0) ;
      }
    }
   printf("Nazwa zbioru wyjsciowego: ") ;
   fgets(filename, MAXFNAME, stdin) ;
   eoln = stripnewlines(filename) ;

   if (( Outfile = fopen(filename, "w")) == 0 )
      {
      fprintf(stdout, "Nie moge otworzyc zbioru %s dla pisania.\n",filename) ;
      exit(0) ;
       }	 
	printf("Pierwszy rekord wyjsciowy powinien miec numer:  ");
	fscanf(stdin,"%d", &NUMER ) ;   	 
  switch (KTORY)
           {
	   case 1 :
        while ( TRUE )
         {
          getword1(&slowo1) ;
	       if (inchar == EOF ) break ;/* wykryto koniec zbioru Infile1 */
          changewtype(&slowo1, &slowo3) ;
			 slowo3.numer = NUMER ;
			 printf("%d ", NUMER ) ;
			 NUMER++  ;
          putword2(&slowo3) ;
			} /* end of while */
			break ;
	   case 2 :	
      case 3 :
	   case 4 :
	   case 5 :		
		 	 getword1(&slowo1) ; 
			 if (inchar == EOF ) break ;/* wykryto koniec zbioru INFILE1 */
		    getword2(&slowo2) ;
			 if (inchar == EOF ) break ;
		while ( TRUE )
		  {
			 i = compareform(&(slowo1.haslo), &(slowo2.haslo) ) ;
			 
			 if ( i == 0 )
			    { mergeword (&slowo1, &slowo2, &slowo3) ;
				   slowo3.numer = NUMER ;
					if (KTORY == 5) liczDU(&slowo3) ;
					printf("%d ", NUMER ) ;   /* kontrola na ekranie */
					NUMER++ ;
				   putword2(&slowo3) ; 
					getword1(&slowo1) ; 
					if (inchar == EOF ) 
					{ noeof11 = FALSE ;
					 break;
					 }
					getword2(&slowo2) ;
					if (inchar == EOF ) 
					{ noeof21 = FALSE ;
					 break;
					 } 
					
				 }  
			 else 
			     { if ( i < 0 )
				     { changewtype(&slowo1, &slowo3) ;
					    slowo3.numer = NUMER ;
						 if (KTORY == 5) liczDU(&slowo3) ;
						 printf("%d ", NUMER ) ;  /* kontrola na ekranie */
						 NUMER++ ;
						 putword2(&slowo3) ; 
						 getword1(&slowo1) ; 
						 if (inchar == EOF ) 
				        	{ noeof12 = FALSE ;
					        break;
					      }
					  } else { slowo2.numer = NUMER ;
					           if (KTORY == 5 ) liczDU(&slowo2) ;
					           printf("%d ", NUMER ) ; /* kontrola na ekranie */
					           NUMER++ ;
								  putword2(&slowo2) ; 
								  getword2(&slowo2) ;
								  if (inchar == EOF ) 
				               	{ noeof23 = FALSE ;
					                 break;
					                 }
								 }
					}
			} /* end of while */
	if (!noeof11)
	   { while ( TRUE )
		     { getword2(&slowo2);
			    if (inchar == EOF ) break ;
				 slowo2.numer = NUMER ;
				 if (KTORY == 5 ) liczDU(&slowo2) ;
				 printf("%d ", NUMER ) ; /* kontrola na ekranie */
				 NUMER++ ;
				 putword2(&slowo2);
				}
		}
	if (!noeof21 || !noeof23)
	   { changewtype(&slowo1, &slowo3) ;
		  slowo3.numer = NUMER ;
		  if (KTORY == 5) liczDU(&slowo3) ;
		  printf("%d ", NUMER ) ; /* kontrola na ekranie */
		  NUMER++ ;
		  putword2(&slowo3) ;
		  while ( TRUE )
		     { getword1(&slowo1) ;
			    if (inchar == EOF ) break ;
			    changewtype(&slowo1, &slowo3) ;
				 slowo3.numer = NUMER ;
				 if (KTORY == 5) liczDU(&slowo3) ;
		       printf("%d ", NUMER ) ; /* kontrola na ekranie */
		       NUMER++ ;
		       putword2(&slowo3) ;
				}
		}		 
	if (!noeof12)
	    { while ( TRUE ) 
		      {  slowo2.numer = NUMER ;
				   if (KTORY == 5 ) liczDU(&slowo2) ;
		         printf("%d ", NUMER ) ; /* kontrola na ekranie */
		         NUMER++ ; 
				   putword2(&slowo2) ;
				  getword2(&slowo2) ;	
		     	  if ( inchar == EOF ) break ;
				 }
		 }		  		 		
	  break ;
  case 6 :
         while (TRUE)
			 {
  			 getword2(&slowo2) ;
			 if (inchar == EOF ) break ;/* wykryto koniec zbioru INFILE2 */  
          if ( slowo2.haslo.frekw[5] > JAKIE )
			       {  printf("%d ", NUMER ) ;
					    slowo2.numer = NUMER ;
						 NUMER++ ;
		             putword2(&slowo2) ;
					  }	
				}
	  break ;						
  case 7 :		
         while (TRUE)
			 {
  			 getword2(&slowo2) ;
			 if (inchar == EOF ) break ;/* wykryto koniec zbioru INFILE2 */  
          if ( (slowo2.haslo.plus == 0)&&
	       (slowo2.haslo.kropka == 0) )
			       {  printf("%d ", NUMER ) ;
					    slowo2.numer = NUMER ;
						 NUMER++ ;
		             putword2(&slowo2) ;
					  }	
				}
	break ;						  	  
  case 8 :  /* dane dla texa */
         while (TRUE)
			  {
			  getword3(&slowo4) ;
			  if (inchar == EOF ) break ;
			  puttex(&slowo4) ;
			  }
   break ;

 case 9 :   /* laczenie wskazanych hasel */
       	  {  getword2(&slowo2) ;
			  if (inchar == EOF ) break ;
		
		  while (TRUE)
		      if (slowo2.haslo.kod != 0)
			       {  printf("%d ", NUMER ) ;
					    slowo2.numer = NUMER ;
						 NUMER++ ;
		             putword2(&slowo2) ;
					      getword2(&slowo2) ;
		          	  if (inchar == EOF ) break ;
					  }	
					   else
						  { getword2(&slowo3) ;
						    if (inchar ==  EOF ) 
							 { printf("%d ", NUMER ) ;
					         slowo2.numer = NUMER ;
						      NUMER++ ;
		                  putword2(&slowo2) ;
								break ;
								}
							 i = stringcmp( slowo2.haslo.forma, 
							                slowo3.haslo.forma  ) ;
							 						 	
								if ( i == 0 ) 
								  { printform2( &(slowo2.haslo) ) ;
						       printform2( &(slowo3.haslo) ) ;
						       printf("\n") ;
							 inc = getch() ; printf("\n%c", inchar) ;
							 if (inc == ' ')
						 {  merge( &slowo2, &slowo3, &slowo5 ) ;
						    liczDU(&slowo5) ;
						    printf("%d ", NUMER ) ;
					                   slowo5.numer = NUMER ;
						                NUMER++ ;
		                            putword2(&slowo5) ;
					 				   getword2(&slowo2) ;
			                     if (inchar == EOF ) break ;
		                       } else {
									    printf("%d ", NUMER ) ;
					                   slowo2.numer = NUMER ;
						                NUMER++ ;
		                            putword2(&slowo2) ;
	 				       slowo2 = slowo3 ;
						 }
						 }
						 else {
					       printf("%d ", NUMER ) ;
		                   slowo2.numer = NUMER ;
			                NUMER++ ;
		                            putword2(&slowo2) ;
					 				       slowo2 = slowo3 ;
											 }
                      }		
			  }
   break ;
 case 10 :
         i = -1 ;
         while (TRUE)
			  {
			  getword2(&slowo2) ;
			  if (inchar == EOF ) break ;
			  changewtype23( &slowo2, &slowo4 );
			 			 
			  while ( TRUE )		 
			    { if ( i <= 0 )
					 {k = getform1(&slowo) ;
				/*	  printform1(&slowo) ; */
			       if ( k == 0 ) break ;}
			     	i = compareform( &slowo, &(slowo4.haslo) ) ;
			      if ( i >= 0 ) break ;
				  } 
				  if (k== 0 ) break ;
				if ( i == 0 )   { i = -1 ;
			                slowo4.mowa = slowo.frekw ;}	
			  putword3(&slowo4) ;
			  }
   break ;
	
 case 11 :
   while (TRUE)
			  {
			  getword3(&slowo4) ;
			  if (inchar == EOF ) break ;
		 fprintf(Outfile, "{%8.2f}", /*slowo4.D */ slowo4.U ) ;
        /* fprintf(Outfile, "{%5d}", slowo4.haslo.frekw[5]) ;*/		
	   put2rang( &(slowo4.haslo) ) ;
	   }
   break ;		
	 
	 
	 }    /* end of case instruction */ 
				 
	 fclose(Infile1) ;  fclose(Infile2) ;  fclose(Outfile) ;
      }    /* end of main program */

VOID liczDU(word)
WORDTYPE2 *word ;
     { /* wyliczanie parametrow D i U */
  int i ;
  double efsred, suma, s, s1, v, De ;
  
  efsred = ((*word).haslo.frekw[5])/5.0 ;
  
  suma = 0.0 ;
  i = 0 ;
  while ( i != 5 )
    { s1 = (*word).haslo.frekw[i] ;
	   suma = suma + ((s1 - efsred) * (s1 - efsred)) ;
		i++ ;
		 }
		
	 s = sqrt( suma/4.0 ) ;
	 v = s/efsred ;
	 De = 1.0 - (v / sqrt(5.0)) ;
	 if ( De < 0.0 ) De = -1.0 * De ;
	 (*word).D = 100.0 * De ;
	 (*word).U = De * ((*word).haslo.frekw[5]) ;	 
	 
	       } /* end of liczDU */
	  
int stripnewlines(string)
char string[] ;
       {   /* stripnewlines */
   int I ;
   int yes ;
         yes = 0 ;
	 for ( I = 0 ; string[I] ; I++ )
	    if ( string[I] == '\n' )
	        {  string[I] = '\0' ;
		   yes = 1 ;
		   break ;    }
    return ((yes == 1) ? TRUE : FALSE );
         }   /* stripnewlines */

 VOID getword1(haslo)
 WORDTYPE1 *haslo ;
          { /* getword1 */

	int   i ;
	int   last;
	FORMTYPE1   forma ;
   
	last = FALSE ;
	last = getform1(&forma) ; /* printform1(&forma) ;*/
	if (inchar == EOF) return ;
	copyf1( &forma, &((*haslo).haslo) ) ;
	  
	i = 0 ;
	last = FALSE ;
	last = getform1(&forma) ; /* printform1(&forma) ;*/
	while (last)
	      {
		   copyf1( &forma, &((*haslo).forma[i]) ) ;
		    i++ ;
	    	 last = FALSE ;
        	 last = getform1(&forma) ; /* printform1(&forma) ;*/
			 	 }
			(*haslo).ileform = i ;				 
		 
	      (*haslo).ilosc = forma.frekw ;  
	  } /* end of getword1 */

  VOID copyf1( f1, f2 )
  FORMTYPE1 *f1,*f2 ;
      { /* kopiuje f1 na f2 */
		(*f2).frekw = (*f1).frekw ;
		strcpy ((*f2).forma,  (*f1).forma) ;
		(*f2).kropka = (*f1).kropka ;
		(*f2).plus = (*f1).plus ;
		(*f2).kod = (*f1).kod ;
		}
		  
 VOID copyf2( f1, f2 )
 FORMTYPE2 *f1,*f2 ;
      { /* kopiuje f1 na f2 */
	int i ;
	i = 0 ;
	while (i < 6 )
		{
		(*f2).frekw[i] = (*f1).frekw[i] ;
		i++ ;
		}
		strcpy ((*f2).forma,  (*f1).forma) ;
		(*f2).kropka = (*f1).kropka ;
		(*f2).plus = (*f1).plus ;
		(*f2).kod = (*f1).kod ;
		}
		  
 int getstring(string, Inputfile)
 char string[] ;
 FILE *Inputfile ;
          {
			int i ;
			
			
			i = 0 ;
			inchar = getc(Inputfile) ;/* printf("\n%c", inchar) ;*/
			if (inchar == EOF ) return(TRUE) ;  
			while ( isspace(inchar) )
			 {
			    inchar = getc(Inputfile) ; /*printf("\n%c", inchar) ;*/
				 if (inchar == EOF) return(TRUE) ;  
				 	}
		   
			while( !isspace(inchar) )
			 {
			     string[i] =inchar ;
				  i++ ;
				  inchar = getc(Inputfile) ;
				  if (inchar == EOF ) return(TRUE) ;
				  /*printf("\n%c", inchar) ;*/
				  if (inchar == EOF ) return(TRUE) ; 
				  }
			string[i] = '\0' ;
			
		while (inchar == '\ ') inchar = getc( Inputfile) ;
		/* printf("\n%c",inchar);*/
			if ( !(inchar == '\n') ) ungetc (inchar, Inputfile) ;
			
			return( (inchar == '\n') ? TRUE : FALSE ) ;
			 }

 VOID printword1(haslo)
 WORDTYPE1 *haslo ;
     {
 int i;
 int j;
         i = (*haslo).ileform ;
	      printform1(&((*haslo).haslo)) ;
			j = 0 ;
			while ( j < i )
			    {  printform1(&((*haslo).forma[j])) ;
				    j++ ;
				 }
				 printf("\n%8d", (*haslo).ilosc );
	  }			 	 
	  
 VOID printform1(forma)
 FORMTYPE1 *forma ;
      {  printf("\n") ;
		   printf("%8d", (*forma).frekw ) ;
			printf("  %s", (*forma).forma ) ;
			if ( (*forma).kropka ) printf(" .") ;
			if ( (*forma).plus ) printf(" + ") ;
			       else printf("  ") ;
		   if (!((*forma).kod == 0)) printf("%d", (*forma).kod) ;
		  }
		  	 	  

 int getform1(forma)
 FORMTYPE1 *forma ;
          { /* getform1 - zwraca jedynke gdy forma
	       nie jest ostatnia w paradygmacie tzn.
	       nie jest to tylko liczba	*/

        int cyfra ;
		  int plus ;
		  int  kropka ;
		  int  doklej ;
        int  eoln ;
	     int  liczba ;
		  	char  string[MAXFORMLEN] ;
      	char  znak ;
			
			kropka = FALSE ;
			plus = FALSE ;
			cyfra = FALSE ;
			doklej = FALSE ;
			(*forma).kropka = FALSE ;
		(*forma).kod = 0 ;
		(*forma).plus = FALSE ;
			
/* ----------------------- czestosc ---------------------- */			
           eoln = getstring(string, Infile1) ;
			    /*   printf("\n1:%s", string) ;*/
			  if( inchar == EOF ) return (FALSE) ;
	  	  	  (*forma).frekw = atoi(string) ;
		  if (eoln) return(FALSE) ;

/* ----------------------- forma ------------------------- */ 
	       eoln = getstring(string, Infile1) ;
			    /*   printf("\n2:%s", string) ; */
	   	  strcpy((*forma).forma,string) ;
	    if (eoln) return(TRUE) ;

/* ---------------------- jest plus ??? ------------------ */

while (!eoln) 
    {
	       fscanf(Infile1, "%c", &znak) ;
    	   if (isdigit(znak)) cyfra = TRUE ;
	   	if ( znak == '+' ) plus  = TRUE ;
			if ( znak == '.' ) kropka = TRUE ;
			
		   ungetc (znak, Infile1) ;
		if ( !(plus || cyfra || kropka) ) doklej = TRUE ;
		
		
	  eoln = getstring(string, Infile1) ; 
	  /* printf("\n3:%s", string) ;*/
	    if (doklej) 
		       {
				 sklej(((*forma).forma), string) ;
				 doklej = FALSE ;
				 }
		 else 
		  {  if ( plus ) { (*forma).plus = TRUE ;
		                   plus = FALSE ; }
		    else 
			   { if ( cyfra ) { (*forma).kod = atoi(string) ;
				                 cyfra = FALSE ; } 
				     else 
					   { if (kropka) { (*forma).kropka = TRUE ;
						                kropka = FALSE ; }
				      }
				}
			}
		}	
		  if (eoln) return(TRUE) ;
   	
	 } /* end of getform1 */

VOID sklej(string1, string2)
char string1[] ;
char string2[] ;
     {
	  strcat(string1, "" ) ;
	  strcat(string1, " " ) ;
	  strcat(string1, string2) ;
	  }
 VOID getword2(haslo)
 WORDTYPE2 *haslo ;
          { /* getword2 */
			 
	int   i ;
	int   last;
	float k ;
	FORMTYPE2   forma ;
   
	fscanf(Infile2, "%f", &k ) ;
	(*haslo).D = k ;
	fscanf(Infile2, "%f", &k ) ;
	(*haslo).U = k ;
	last = FALSE ;
	last = getform2(&forma) ;
	if (inchar == EOF) return ;
	copyf2( &forma, &((*haslo).haslo) ) ;
	  
	i = 0 ;
	last = FALSE ;
	last = getform2(&forma) ;
	while (last)
	      {
		   copyf2( &forma, &((*haslo).forma[i]) ) ;
		    i++ ;
	    	 last = FALSE ;
        	 last = getform2(&forma) ;
			 	 }
			(*haslo).ileform = i ;				 
		 
	      (*haslo).numer = forma.frekw[0] ;  
	
	  } /* end of getword2 */


 VOID getword3(haslo)
 WORDTYPE3 *haslo ;
          { /* getword2 */
			 
	int   i ;
	int   last;
	float k ;
	FORMTYPE2   forma ;
   
	fscanf(Infile2, "%f", &k ) ;
	(*haslo).D = k ;
	fscanf(Infile2, "%f", &k ) ;
	(*haslo).U = k ;
	fscanf(Infile2, "%d", &i ) ;
	(*haslo).mowa = i ;
	last = FALSE ;
	last = getform2(&forma) ;
	if (inchar == EOF) return ;
	copyf2( &forma, &((*haslo).haslo) ) ;
	  
	i = 0 ;
	last = FALSE ;
	last = getform2(&forma) ;
	while (last)
	      {
		   copyf2( &forma, &((*haslo).forma[i]) ) ;
		    i++ ;
	    	 last = FALSE ;
        	 last = getform2(&forma) ;
			 	 }
			(*haslo).ileform = i ;				 
		 
	      (*haslo).numer = forma.frekw[0] ;  
	
	  } /* end of getword32 */

 int getform2(forma)
 FORMTYPE2 *forma ;
          { /* getform2 - zwraca jedynke gdy forma
	       nie jest ostatnia w paradygmacie tzn.
	       nie jest to tylko liczba	*/

        int cyfra ;
		  int plus ;
		  int  kropka ;
		  int  doklej ;
        int  eoln ;
	     int  liczba ;
		  	char  string[MAXFORMLEN] ;
      	char  znak ;
			int i ;
			
			
			kropka = FALSE ;
			plus = FALSE ;
			cyfra = FALSE ;
			doklej = FALSE ;
			(*forma).kropka = FALSE ;
			(*forma).plus = FALSE ;
	   	(*forma).kod = 0 ;
/* ----------------------- numer ------------------------- */
           eoln = getstring(string, Infile2) ;
			  if (inchar == EOF ) return (FALSE) ;
			  (*forma).frekw[0] = atoi(string) ;
			  if (eoln) return(FALSE) ;		
			
/* ----------------------- czestosc ---------------------- */
           i = 1 ;
			while (i < 6)
			   { 			
           eoln = getstring(string, Infile2) ;
			  if( inchar == EOF ) return (FALSE) ;
	  	  	  (*forma).frekw[i] = atoi(string) ;
			  i++ ;
			    }
		  if (eoln) return(TRUE) ;

/* ----------------------- forma ------------------------- */ 
	       eoln = getstring(string, Infile2) ;
	   	  strcpy((*forma).forma,string) ;
	    if (eoln) return(TRUE) ;

/* ---------------------- jest plus ??? ------------------ */
  while(!eoln) 
    {

	       fscanf(Infile2, "%c", &znak) ;
    	   if (isdigit(znak)) cyfra = TRUE ;
	   	if ( znak == '+' ) plus  = TRUE ;
			if ( znak == '.' ) kropka = TRUE ;
			
		   ungetc (znak, Infile2) ;
		if ( !(plus || cyfra || kropka) ) doklej = TRUE ;
		
		
	  eoln = getstring(string, Infile2) ;
	    if (doklej) 
		       {
		       sklej(((*forma).forma), string) ;
				 doklej = FALSE ;
				 }
		 else 
		  {  if ( plus ) {(*forma).plus = TRUE ;
		                  plus = FALSE ; }
		    else 
			   { if ( cyfra ) {(*forma).kod = atoi(string) ;
				                cyfra = FALSE ; }  
				    else
					  { if ( kropka ) {(*forma).kropka = TRUE ;
					                   kropka = FALSE ; }
					  }
				 }
		  }
	}/* end of while */			 
		  if (eoln) return(TRUE) ;
    
  } /* end of getform2 */

 VOID printform2(forma)
 FORMTYPE2 *forma ;
      {  
		int i ;
			printf("\n") ;
			i = 0 ;
			while ( i < 6 ) 
			 { 
			 printf("%6d", (*forma).frekw[i] ) ;
			 i++ ;
			  }
			printf("  %s", (*forma).forma ) ;
			if ( (*forma).kropka ) printf(" .") ;
			if ( (*forma).plus ) printf(" + ") ;
			       else printf("  ") ;
		   if ((*forma).kod != 0) printf("%d", (*forma).kod) ;
		  } /* end of printform2 */

 VOID printword2(haslo)
 WORDTYPE2 *haslo ;
     {
 int i;
 int j;
         printf("%9.4f %9.4f", (*haslo).D, (*haslo).U ) ;
			
         i = (*haslo).ileform ;
			
	      printform2(&((*haslo).haslo)) ;
			j = 0 ;
			while ( j < i )
			    {  printform2(&((*haslo).forma[j])) ;
				    j++ ;
				 }
		    printf("\n%6d\n", (*haslo).numer) ;
	  }	/* end of printword2 */		 	 

 VOID putword2(haslo)
 WORDTYPE2 *haslo ;
           { /* putword */
 int i;
 int j;
         fprintf(Outfile, "%6.2f %6.2f", (*haslo).D, (*haslo).U ) ;
         i = (*haslo).ileform ;
			
	      putform2(&((*haslo).haslo)) ;
			j = 0 ;
			while ( j < i )
			    {  putform2(&((*haslo).forma[j])) ;
				    j++ ;
				 }
		   fprintf(Outfile, "\n%5d\n", (*haslo).numer) ;		 
		} /* end of putword */

 VOID putword3(haslo)
 WORDTYPE3 *haslo ;
           { /* putword */
 int i;
 int j;
         fprintf(Outfile, "%6.2f %6.2f", (*haslo).D, (*haslo).U ) ;
         fprintf(Outfile, "%5d", (*haslo).mowa ) ;
	 i = (*haslo).ileform ;
			
	      putform2(&((*haslo).haslo)) ;
			j = 0 ;
			while ( j < i )
			    {  putform2(&((*haslo).forma[j])) ;
				    j++ ;
				 }
		   fprintf(Outfile, "\n%5d\n", (*haslo).numer) ;		 
		} /* end of putword */

 VOID puttex(haslo)
 WORDTYPE3 *haslo ;
           { /* puttex - procedura wyprowadza rekord w postaci
			       czytelnej dla tex'a  */
 int i, k, j;

         fprintf(Outfile, "\\fl{%s}{", (*haslo).haslo.forma ) ;
			
			if ( (*haslo).haslo.kropka != 0 )
			   fprintf(Outfile, "." ) ; 
		   
			puttexkod( (*haslo).haslo.kod ) ;
			
			
			if ( (*haslo).haslo.plus != 0 )
			   fprintf(Outfile, "*" ) ;
			
			fprintf(Outfile, "}\n" ) ;
			
			fprintf(Outfile,"\\sl" ) ;
			i = 0 ;
			while ( i < 6 )
			   {
			fprintf(Outfile, "{%d}", (*haslo).haslo.frekw[i] ) ;
				i++ ;
				} 	

         fprintf(Outfile, "{%5.2f}", (*haslo).D ) ;
	 fprintf(Outfile, "{%5.2f}", (*haslo).U ) ;
	 fprintf(Outfile, "{(%d)}\n", (*haslo).mowa ) ;
		
	   j = (*haslo).ileform ;
		i = 0 ;	
		 while ( i < j )
		    {  fprintf(Outfile, "\\ol" ) ;
                       k = 0 ;
		  while ( k < 6 )
	            { fprintf(Outfile, "{%d}", (*haslo).forma[i].frekw[k] ) ;
		      k++ ;
		    }
			   
		fprintf(Outfile, "{%s}{", (*haslo).forma[i].forma ) ;
		if ( (*haslo).forma[i].kropka != 0 )
				   fprintf(Outfile, "." ) ;
		
		puttexkod( (*haslo).forma[i].kod ) ;
		
		if ( (*haslo).forma[i].plus != 0	)
				   fprintf(Outfile, "*" ) ;
				 
		fprintf(Outfile, "}\n" ) ;
				
				i++ ;
				}			 	 
				   	 
		} /* end of putword */
VOID puttexkod(kod)
int kod ;
      { /* procedura zmienia gramatyczny kod cyfrowy na kod opisowy
           i wpisuje go do zbioru Outfile */ 

switch(kod)
 {  case 1: fprintf(Outfile, "S") ;
            break ;
    case 2: fprintf(Outfile, "Adj") ;
            break ;
    case 3: fprintf(Outfile, "Num") ;	    	        
            break ;
    case 4: fprintf(Outfile, "Prn") ;
            break ;	    
    case 5: fprintf(Outfile, "V"  ) ;
            break ;
    case 6: fprintf(Outfile, "Prp" ) ;
            break ;
    case 7: fprintf(Outfile, "Int" ) ;
            break ;
    case 8: fprintf(Outfile, "Adv" ) ;
            break ;
    case 9: fprintf(Outfile, "Cnj" ) ;
            break ;
    case 10: fprintf(Outfile, "Prt" ) ;
             break ;	    
    
    case 111:
    case 211: fprintf(Outfile, "{$_{Nsg}$}") ;
              break ;
    case 112:
    case 212: fprintf(Outfile, "{$_{Npl}$}") ;
              break ;
    case 121:
    case 221: fprintf(Outfile, "{$_{Gsg}$}") ;
              break ;
    case 122:
    case 222: fprintf(Outfile, "{$_{Gpl}$}") ;
              break ;
    case 131:
    case 231: fprintf(Outfile, "{$_{Dsg}$}") ;
              break ;	      	      	      	         	    	    
    case 132:
    case 232: fprintf(Outfile, "{$_{Dpl}$}") ;
              break ;
    case 141:
    case 241: fprintf(Outfile, "{$_{Asg}$}") ;
              break ;
    case 142:
    case 242: fprintf(Outfile, "{$_{Apl}$}") ;
              break ; 
    case 151: 
    case 251: fprintf(Outfile, "{$_{Isg}$}") ;
              break ;
    case 152: 
    case 252: fprintf(Outfile, "{$_{Ipl}$}") ;
              break ;
    case 161: 
    case 261: fprintf(Outfile, "{$_{Lsg}$}") ;
              break ;
    case 162: 
    case 262: fprintf(Outfile, "{$_{Lpl}$}") ;
              break ;
    case 171: fprintf(Outfile, "{$_{Vsg}$}") ;
              break ;
    case 172: fprintf(Outfile, "{$_{Vpl}$}") ;
              break ;
    case  31:
    case  41: fprintf(Outfile, "{$_{N}$}") ;
              break ;
    case  32:
    case  42: fprintf(Outfile, "{$_{G}$}") ;
              break ;
    case  33:
    case  43: fprintf(Outfile, "{$_{D}$}") ;
              break ;
    case  34:
    case  44: fprintf(Outfile, "{$_{A}$}") ;
              break ;
    case  35:
    case  45: fprintf(Outfile, "{$_{I}$}") ;
              break ;
    case  36: 
    case  46: fprintf(Outfile, "{$_{L}$}") ;
              break ;
    case  501:fprintf(Outfile, " si@e") ;
              break;
    case  50: fprintf(Outfile, "{$_{V}$}" ) ;
              break ;	      
    case  511:
    case  521:fprintf(Outfile, " si@e") ;
    case  51:
    case  52: fprintf(Outfile, "{$_{fut}$}" ) ;
              break ;
    case  531:fprintf(Outfile, " si@e") ;
    case 53: fprintf(Outfile, "{$_{mob}$}" ) ;
              break ;
    case  541:fprintf(Outfile, " si@e") ;
    case 54: fprintf(Outfile, "{$_{cnd}$}" ) ;
              break ;
    case  551:fprintf(Outfile, " si@e") ;
    case 55: fprintf(Outfile, "{$_{imp}$}" ) ;
              break ;
    case  56: fprintf(Outfile, "{$_{aux}$}" ) ;
              break ;
    case  57: fprintf(Outfile, "{$_{pass}$}" ) ;
	      break ;	      	      
    case  61: fprintf(Outfile, "{$_{N}$}" ) ;
              break ;
    case  62: fprintf(Outfile, "{$_{G}$}" ) ;
              break ;
    case  63: fprintf(Outfile, "{$_{D}$}" ) ;
              break ;
    case  64: fprintf(Outfile, "{$_{A}$}" ) ;
              break ;
    case  65: fprintf(Outfile, "{$_{I}$}" ) ;
              break ;
    case  66: fprintf(Outfile, "{$_{L}$}" ) ;
              break ;	      	      	      	       	      	      	      	       	      	       	       
     default: 
          if (kod != 0 ) fprintf(Outfile, "%d", kod) ;
          else fprintf(Outfile, " " ) ;
          break ;
  }	  
    
} /* end of puttexkod */ 
  
 VOID changewtype(haslowe, haslowy)
 WORDTYPE1 *haslowe ;
 WORDTYPE2 *haslowy ;
           { /* changewtype wstawia haslo wejsciowe
			  w strukture hasel wyjsciowych, frekwencja
			  wstawiana jest w KTORY-1 kolumne frekwencji
			  w strukturze wyjsciowej, jako suma (6-ta 
			  kolumna) wstawiana jest zawartosc kolumny KTORY-1 */  
			  	  
			  int i,j ;
			  
			  j = (*haslowe).ileform ;

           (*haslowy).ileform = j ;
			  
			  copyf1f2(&((*haslowe).haslo), &((*haslowy).haslo)) ;
			  (*haslowy).numer = (*haslowe).haslo.frekw ;
			  (*haslowy).haslo.frekw[KTORY-1] = (*haslowe).ilosc ;
			  (*haslowy).haslo.frekw[5] = (*haslowe).ilosc ;
			  
			  i = 0 ;
 while (i < j) 
	 { copyf1f2(&((*haslowe).forma[i]), &((*haslowy).forma[i]) ) ;
	   (*haslowy).forma[i].frekw[5] = (*haslowy).forma[i].frekw[KTORY-1] ;
		i++ ;
	  }
	   (*haslowy).D = 0.0 ;
		(*haslowy).U = 0.0 ;
	     }  /* end of changewtype  */


 VOID changewtype23(haslowe, haslowy)
 WORDTYPE2 *haslowe ;
 WORDTYPE3 *haslowy ;
           { /* changewtype wstawia haslo wejsciowe
			  w strukture hasel wyjsciowych, frekwencja
			  wstawiana jest w KTORY-1 kolumne frekwencji
			  w strukturze wyjsciowej, jako suma (6-ta 
			  kolumna) wstawiana jest zawartosc kolumny KTORY-1 */  
			  	  
			  int i,j ;
			  
			  j = (*haslowe).ileform ;

           (*haslowy).ileform = j ;
			  
			  copyf2(&((*haslowe).haslo), &((*haslowy).haslo)) ;
			  (*haslowy).numer = (*haslowe).numer ;
			  i=0 ;
          while (i < 6)			  
              { (*haslowy).haslo.frekw[i] = (*haslowe).haslo.frekw[i] ; 
				    i++ ; }
			  
			  i = 0 ;
 while (i < j) 
	 { copyf2(&((*haslowe).forma[i]), &((*haslowy).forma[i]) ) ;
	   i++ ;
	  }
	   (*haslowy).D = (*haslowe).D ;
		(*haslowy).U = (*haslowe).U ;
		(*haslowy).mowa = 0 ;
	     }  /* end of changewtype  */
		  
 VOID copyf1f2(fwe, fwy)
 FORMTYPE1 *fwe ;
 FORMTYPE2 *fwy ;
 
     { /* procedura kopije fwe na fwy, frekwencja
	       wstawiana jest do kolumny o numerze KTORY - 1              */
			 
         int i, k ;
           i = 0 ; k = KTORY -1 ;
			  while ( i < 6 ) 
			   {  (*fwy).frekw[i] = 0 ;
				   i++ ;
				}
				
				(*fwy).frekw[k] = (*fwe).frekw ;
				strcpy (((*fwy).forma),((*fwe).forma) ) ;
				(*fwy).kropka = (*fwe).kropka ;
				(*fwy).plus = (*fwe).plus ;
				(*fwy). kod = (*fwe).kod ;
			} /* end of copyf1f2 */		 			   		  
		  
 VOID putform2(forma)
 FORMTYPE2 *forma ;
       {
		 
		int i ;
			fprintf(Outfile, "\n") ;
			i = 0 ;
			while ( i < 5 ) 
			 { 
			 fprintf(Outfile, "%5d", (*forma).frekw[i] ) ;
			 i++ ;
			  }
			 fprintf(Outfile, "%6d", (*forma).frekw[i] ) ;
		
			fprintf(Outfile, " %s", (*forma).forma ) ;
			if ( (*forma).kropka ) fprintf(Outfile, " .") ;
			if ( (*forma).plus ) fprintf(Outfile, " + ") ;
			       else fprintf(Outfile, " ") ;
		   if ((*forma).kod != 0) fprintf(Outfile, "%d", (*forma).kod) ;
	
			 } /* end of putform2 */ 	 	  


 VOID put2rang(forma)
 FORMTYPE2 *forma ;
       {
		 
		int i ;
			fprintf(Outfile, "{%s}", (*forma).forma ) ;
		        fprintf(Outfile, "{%d}", (*forma).kod) ;
	      fprintf(Outfile, "\n") ;
			 } /* end of put2rang */ 	 	  
			  	  
  int stringcmp(String1, String2)
  char *String1 ;
  char *String2 ;

       { /* stringcmp zwraca wartosc w
		 w = 0 stringi sa rowne,
		 w < 0 pierwszy wczesniejszy niz drugi,
		 w > 0 drugi wczesniejszy niz pierwszy        */
 	 
		 
 for ( /* no initialization */ ; (*String1 == *String2 ); 
                                     String1++, String2++ )
	if (*String1 == '\0') return(0) ;
	
	
	if (*String1 == '\0' ) return(-1) ;
	if (*String2 == '\0' ) return(1) ; 
  if ( *(String1-1) == '@'  &&  *(String2-1) == '@' )
	   {  
	     if (*String1 == 'r')  return(1) ; 
	       else {
		       if (*String2 == 'r')  return(-1) ; 
				   else 
			return (*String1 - *String2) ; 
       	            }
	   }
	
	if ((isalpha(*String1) || isspace(*String1)) && 
	   (isalpha(*String2) || isspace(*String2))) 
	        	        { /* printf("\n*1*") ; */
				    return( *String1 - *String2 ) ; }
	if (isspace(*String1) && *String2 == '-' ) return(-1) ;
	if (isspace(*String2) && *String1 == '-' ) return(1) ;						  
   if (isalpha(*String1) && *String2 == '-' ) return(1) ;
	if (isalpha(*String2) && *String1 == '-' ) return(-1) ;						 
	if (isalpha(*String1) && *String2 == '[' ) return(1) ;
	if (isalpha(*String2) && *String1 == '[' ) return(-1) ;						 
 	if (*String1 == '@' ) 
	  { String1++ ;
	    if( *String1 == *String2 ) return (1) ;
		  else { if (*String1 != 'r' ) { /* printf("\n*3*") ; */
	                                return( *String1 - *String2 ) ; }
		          else return (1) ;
					 }
	  }
	else 
	{   
	if (*String2 == '@') 
	  { String2++ ;
	    if( *String1 == *String2 ) return(-1) ;
		  else { if (*String2 != 'r' ) { /* printf("\n*4*") ; */
	                                return ( *String1 - *String2 ) ; }
		          else return(-1) ;
					 }
		}
		}			 
	} /* end of stringcmp */
	
int compareform( form1, form2 )
FORMTYPE1 *form1 ;
FORMTYPE2 *form2 ;
   { /* compareform porownuje formy i zwraca w
	     w = 0 gdy formy sa identyczne,
		  w < 0 gdy pierwsza jest wczesniejsza od drugiej,
		  w > 0 gdy druga jest wczesniejsza od pierwszej. */
		  
  int kod1 ;
  int kod2 ;
  int p1 ;
  int p2 ;
  int k1 ;
  int k2 ;
  int i ;
    i = stringcmp( (*form1).forma, (*form2).forma  ) ;
   /* printf("\n%s", (*form1).forma) ;
	 printf("\n%s", (*form2).forma) ;
	 printf("\n%d", i ) ; 	*/
	
	 if ( i < 0 ) return(-1) ;
	 if ( i > 0 ) return(1) ;
	 p1 = (*form1).plus ;
	 p2 = (*form2).plus ;
	 if ( p1 != p2 ) return(p1 - p2) ;
	 k1 = (*form1).kropka ;
	 k2 = (*form2).kropka ;
	 if ( k1 != k2 ) return(k1 - k2) ;
	 kod1 = (*form1).kod ;
	 kod2 = (*form2).kod ;
	 if ( KTORY == 10 )
	   { if ( kod1 != 0 && kod2 == 0 )
	        return(0) ;
	   }
	   if ( kod1 == 0 && kod2 == 0 ) return(0) ;
	   else return(kod1 - kod2) ;
  } /* end of compareform */
  		  		  					 
int comparefm( form1, form2 )
FORMTYPE2 *form1 , *form2 ;
   { /* compareform porownuje formy i zwraca w
	     w = 0 gdy formy sa identyczne,
		  w < 0 gdy pierwsza jest wczesniejsza od drugiej,
		  w > 0 gdy druga jest wczesniejsza od pierwszej. */
		  
  int kod1 ;
  int kod2 ;
  int p1 ;
  int p2 ;
  int k1 ;
  int k2 ;
  int i ;
    i = stringcmp( (*form1).forma, (*form2).forma  ) ;
 /*   printf("\n%s", (*form1).forma) ;
	 printf("\n%s", (*form2).forma) ;
	 printf("\n%d", i ) ; 	
	*/
	 if ( i < 0 ) return(-1) ;
	 if ( i > 0 ) return(1) ;
	 p1 = (*form1).plus ;
	 p2 = (*form2).plus ;
	 if ( p1 != p2 ) return(p1 - p2) ;
	 k1 = (*form1).kropka ;
	 k2 = (*form2).kropka ;
	 if ( k1 != k2 ) return(k1 - k2) ;
	 kod1 = (*form1).kod ;
	 kod2 = (*form2).kod ;
	 if ( kod1 == 0 && kod2 == 0 ) return(0) ;
	   else return(kod1 - kod2) ;
  } /* end of compareform */

VOID mergeword (w1, w2, w3)
WORDTYPE1 *w1 ;
WORDTYPE2 *w2, *w3 ;
   { /* procedura laczy identyczne hasla w1 i w2 i wpisuje je
	     do hasla w3 uwzgledniajac wartosc zmiennej globalnej
		  KTORY                                                   */
int if1, if2, if3, i1, i2, i3, j, k, l ;
	    copyf2( &((*w2).haslo), &((*w3).haslo)) ;
		 if ( (*w2).haslo.kod == 0 && (*w1).haslo.kod != 0 )
		                   (*w3).haslo.kod = (*w1).haslo.kod ;
								 
		 if1 = (*w1).ileform ;
		 if2 = (*w2).ileform ;
		 if3 = 0 ;
		 i1 = 0 ; i2 = 0 ; i3 = 0  ;
		 while ( (i1 < if1) && (i2 < if2) )
		  { j = compareform( &((*w1).forma[i1]), &((*w2).forma[i2]) ) ;
		 	 if ( j == 0 )
			   { mergeform(&((*w1).forma[i1]),&((*w2).forma[i2]),
				                                       &((*w3).forma[i3])) ;
				  i1++ ;
				  i2++ ;
				  i3++ ;
			   }
         else { if ( j < 0 ) 
			   { copyf1f2(&((*w1).forma[i1]),&((*w3).forma[i3]) ) ;
				  (*w3).forma[i3].frekw[5] = (*w1).forma[i1].frekw ;
              i1++ ;
				  i3++ ;
			    }
             else
				  { copyf2(&((*w2).forma[i2]), &((*w3).forma[i3]) );
				  i2++ ;
				  i3++ ;
				 } }
	    } /* end of while */	
	   while (i1 < if1)
			     { copyf1f2(&((*w1).forma[i1]), &((*w3).forma[i3]) ) ;
				  (*w3).forma[i3].frekw[5] = (*w1).forma[i1].frekw ;
				    i1++ ;
					 i3++ ; }
		while ( i2 < if2 )
		        { copyf2( &((*w2).forma[i2]), &((*w3).forma[i3]) ) ;
			       i2++ ;
				    i3++ ;  }
			 
/* ---------------------------------------------------------------------- */
       (*w3).ileform = i3 ;
		 		 
		 (*w3).numer = (*w2).numer ;
		 j = 0 ; k = 0 ; l = 0 ;
		 while ( j < i3 )
		   { k = k + (*w3).forma[j].frekw[KTORY-1] ;
			  l = l + (*w3).forma[j].frekw[5] ;
			  j++ ; }
			  
		 (*w3).haslo.frekw[KTORY-1] = k ;
		 (*w3).haslo.frekw[5] = l ;
		 (*w3).D = 0.0 ;
		 (*w3).U = 0.0 ;
		 	} /* end of mergeword */
	
VOID mergeform (f1, f2, f3)
FORMTYPE1 *f1 ;
FORMTYPE2 *f2, *f3 ;
     { /* mergeform laczy formy f1 i f2 w f3 z uwzglednieniem
	       zmiennej globalnej KTORY        */ 
	    copyf2( &(*f2), &(*f3) ) ;
		 (*f3).frekw[KTORY-1] = (*f1).frekw ;
		 (*f3).frekw[5] = (*f3).frekw[5] + (*f1).frekw ;
		 if ((*f1).kod != 0 ) (*f3).kod = (*f1).kod ;
		} /* end of mergeform */
		
VOID merge(w1, w2, w3)
WORDTYPE2 *w1, *w2, *w3 ;
   { /* procedura laczy identyczne hasla w1 i w2 i wpisuje je
	     do hasla w3  */

int if1, if2, if3, i1, i2, i3, i, j, k, l ;
	    copyf2( &((*w2).haslo), &((*w3).haslo)) ;
	/*	 printword2( &(*w1) ) ;
		 printword2( &(*w2) ) ;
	*/	  
								 
		 if1 = (*w1).ileform ;
		 if2 = (*w2).ileform ;
		 if3 = 0 ;
		 i1 = 0 ; i2 = 0 ; i3 = 0  ;
		 while ( (i1 < if1) && (i2 < if2) )
		  { j = comparefm( &((*w1).forma[i1]), &((*w2).forma[i2]) ) ;
		 	 if ( j == 0 )
			   { mergef(&((*w1).forma[i1]),&((*w2).forma[i2]),
				                                       &((*w3).forma[i3])) ;
				  i1++ ;
				  i2++ ;
				  i3++ ;
			   }
         else { if ( j < 0 ) 
			   { copyf2(&((*w1).forma[i1]),&((*w3).forma[i3]) ) ;
				  i1++ ;
				  i3++ ;
			    }
             else
				  { copyf2(&((*w2).forma[i2]), &((*w3).forma[i3]) );
				  i2++ ;
				  i3++ ;
				 } }
	    } /* end of while */	
	   while (i1 < if1)
			     { copyf2(&((*w1).forma[i1]), &((*w3).forma[i3]) ) ;
				    i1++ ;
					 i3++ ; }
		while ( i2 < if2 )
		        { copyf2( &((*w2).forma[i2]), &((*w3).forma[i3]) ) ;
			       i2++ ;
				    i3++ ;  }
			 
/* ---------------------------------------------------------------------- */
       (*w3).ileform = i3 ;
		 		 
		 (*w3).numer = (*w1).numer ;
		 i = 0 ;  
		 while ( i < 6 )
		   {	j = 0 ; k = 0 ;	 
		 while ( j < i3 )
		   { k = k + (*w3).forma[j].frekw[i] ;
			  j++ ; }
			  			  			  
		 (*w3).haslo.frekw[i] = k ;
		 i++ ;
		    }
			 
		 (*w3).D = 0.0 ;
		 (*w3).U = 0.0 ;
		 	} /* end of merge */

			
			
			
VOID mergef (f1, f2, f3)
FORMTYPE2 *f1, *f2, *f3 ;
     { /* mergeform laczy formy f1 i f2 w f3       */
  int i ;
	
    copyf2( &(*f2), &(*f3) ) ;
	 
     i = 0 ;
	  while ( i < 6 )
	   {
	  	  (*f3).frekw[i] = (*f3).frekw[i] + (*f1).frekw[i] ;
		   i++ ;
		}	
		} /* end of mergef */
			     