#!/usr/bin/perl
# Poor Man's Konkordancer
#
# Z plikw ohasowanego korpusu produkuje nowy w formacie:
#   haso@forma@nr probki@tag(i)@kontekst lewy@kontekst prawy

use strict;
use vars qw($preint $forma $haslo $frektag $glotag $postint 
	    $numprobki $numwiersza
	    $dlkont @shasla @sformy @sformyint @stagi @snumwier $ind);

$dlkont = 6;

while (<>) {
    chomp;
#      1      2                                3         4         5          6
if (m/^([(\204]+)?([-a-z\212\232A-Zʣӌ \'\341\350\351\366\374]+)\[([^\[,]*),([^\[,]*),([^\[,]*)\]([).?!,;:\224]+)?$/o) { 
    $preint=$1;
    $forma=$2;
    $haslo=$3;
    $frektag=$4;
    $glotag=$5;
    $postint=$6;
    (print STDERR "Pusta linia wewntrz prbki (l. $.)\n"), $numprobki=0
  	if !defined($numprobki);
    $numwiersza++;
    push @shasla, $haslo;
    push @sformy, $forma;
    push @sformyint, "$preint$forma$postint";
    push @stagi, $glotag;
    push @snumwier, $numwiersza;
    if ($numwiersza > $dlkont) {
	$ind = $#sformy-$dlkont;
	wiersz();
    }
    if ($numwiersza > 2*$dlkont) {
	shift @shasla;
	shift @sformy;
	shift @sformyint;
	shift @stagi;
	shift @snumwier;
    }
 } elsif (m/^(\.\.\.?|--|\227)$/ ||
	  m/^\(?\[[>&\#^~]\]\)?[,.]?$/ ) {
     # czy te s dopuszczalne???
     if (@sformyint) {
	 push @sformyint, ((pop @sformyint) . " $&");
     } else {
	 print STDERR "Swobodna interpunkcja na pocztku prbki $numprobki: $&\n";
     }
 } elsif (m/^([ABCDE][0-9]+)~/) {
     # nagwek prbki!
     $numprobki=$1;
     $numwiersza=0;
     @shasla = ();
     @sformy = ();
     @sformyint = ();
     @stagi = ();
     @snumwier = ();
 } elsif ($_ eq '') {
     flushwiersze();
     undef $numprobki;
 } else {
     print STDERR "$numprobki:$_\n";
 }

}
flushwiersze();

sub flushwiersze {
    while (@sformy > $dlkont) {
	$ind = $dlkont;
	wiersz();
	shift @shasla;
	shift @sformy;
	shift @sformyint;
	shift @stagi;
	shift @snumwier;
    }
}

sub wiersz {
#    return if @tagi < 2;
    print "$shasla[$ind]\@$sformyint[$ind]\@$numprobki\@$stagi[$ind]\@",
    join(' ', @sformyint[0..$ind-1]), "\@", 
    join(' ', @sformyint[$ind+1..$#sformy]), "\n";
#    print "% ", join(' ', @sformyint[0..$ind-1],
#		     "|$sformyint[$ind]|", @sformyint[$ind+1..$#sformy]), "\n";
#    print ">$numprobki:$snumwier[$ind]:",$sformy[$ind],":\n";
#    print "\n";
}




