#! /usr/bin/perl -w
# Poor Man's Konkordancer
#
# Czyta posortowany plik w formacie:
#   haso@forma@nr probki@tag(i)@kontekst lewy@kontekst prawy
# i formatuje konkordancj.

use strict;
use vars qw($haslo $forma $numprobki $tag $lkont $pkont 
	    $prevhaslo $lkontwd $pkontwd $formawd $lkontform $pkontform);

$lkontwd = 36;
$pkontwd = 31;
$formawd = 10;

$prevhaslo = '';



while (<>) {
    chomp;
    ($haslo, $forma, $numprobki, $tag, $lkont, $pkont) = split "@";
    if ($prevhaslo ne $haslo) {
	$prevhaslo = $haslo;
	$formawd = length($haslo) + 3; # staa Kowalskiego
	print "\n_____ " . ("_" x ($lkontwd-1))
	    . " $haslo " . ("_" x (3+14+$pkontwd)) . "\n";
    }
    $lkontform = sprintf "%${lkontwd}s", substr($lkont,-$lkontwd);
    $lkontform =~ s/^[^ ]* /' ' x length($&)/e;
    $pkontform = sprintf "%-${pkontwd}s", substr($pkont,0,$pkontwd);
    $pkontform =~ s/ [^ ]*$/' ' x length($&)/e;
    printf "$numprobki$lkontform %-${formawd}s %s $pkontform\n",
      $forma,
      substr($tag,0,14);
}
