/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.connection;

import ipipan.poliqarp.connection.AsyncHandler;
import java.io.BufferedReader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;

final class MessageReceiver
extends Thread {
    private static final int QUEUE_SIZE = 1000;
    private BlockingQueue<String> msgqueue;
    private SynchronousQueue<String> synqueue;
    private BufferedReader in;
    private AsyncHandler asyncHandler;
    private boolean directUnsafe = false;

    public MessageReceiver(BufferedReader bufferedReader) {
        this.in = bufferedReader;
        this.msgqueue = new ArrayBlockingQueue<String>(1000);
        this.synqueue = new SynchronousQueue();
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public synchronized void setDirectUnsafeMode(boolean bl) {
        this.directUnsafe = bl;
        if (!bl) {
            this.notify();
        }
    }

    public String getSyncMessage() throws InterruptedException {
        return this.synqueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(String string) throws InterruptedException {
        final String string2 = string.substring(2, string.length());
        switch (string.charAt(0)) {
            case 'R': {
                MessageReceiver messageReceiver = this;
                synchronized (messageReceiver) {
                    if (!this.directUnsafe) {
                        this.msgqueue.put(string2);
                    } else {
                        this.synqueue.put(string2);
                    }
                    while (this.directUnsafe) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
            }
            case 'M': {
                if (this.asyncHandler != null) {
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            AsyncHandler asyncHandler = MessageReceiver.this.asyncHandler;
                            synchronized (asyncHandler) {
                                MessageReceiver.this.asyncHandler.handle(string2);
                            }
                        }
                    };
                    thread.start();
                    break;
                }
                System.err.println("async message arrived on null handler: " + string);
                break;
            }
            default: {
                System.err.println("Incorrect message type: " + string);
            }
        }
    }

    public void run() {
        try {
            while (true) {
                String string;
                if ((string = this.in.readLine()) == null) {
                    continue;
                }
                this.dispatch(string);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getMessage() throws InterruptedException {
        String string = this.msgqueue.take();
        return string;
    }
}

