/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.connection;

import ipipan.poliqarp.connection.AsyncHandler;
import ipipan.poliqarp.connection.ConnectionOptions;
import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.MessageReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;

public final class PoliqarpConnection {
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;
    private MessageReceiver receiver;
    private ConnectionOptions options;
    private boolean directUnsafe = false;
    private boolean first = true;

    public PoliqarpConnection(String string, int n) throws IOException, UnknownHostException {
        this.socket = new Socket(string, n);
        this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
        this.receiver = new MessageReceiver(this.in);
        this.options = new ConnectionOptions(this);
        this.receiver.setPriority(10);
        this.receiver.start();
        this.send("MAKE-SESSION GUI");
        if (!this.getMessage().isOK()) {
            throw new IOException();
        }
    }

    public ConnectionOptions getOptions() {
        return this.options;
    }

    public String getServerVersion() {
        try {
            this.send("VERSION");
            return this.getMessage().toString();
        }
        catch (IOException iOException) {
            return "unknown";
        }
    }

    public void close() throws IOException {
        this.send("CLOSE-SESSION");
        if (!this.getMessage().isOK()) {
            throw new IOException();
        }
        this.receiver.interrupt();
        this.socket.close();
        try {
            this.receiver.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.receiver = null;
        this.socket = null;
        this.out = null;
        this.in = null;
    }

    public void send(String string) throws IOException {
        this.out.print(string);
        this.out.print('\n');
        this.out.flush();
    }

    public Message getMessage() throws IOException {
        try {
            if (this.directUnsafe) {
                if (this.first) {
                    this.first = false;
                    return new Message(this.receiver.getSyncMessage());
                }
                String string = this.in.readLine();
                return new Message(string.substring(2, string.length()));
            }
            return new Message(this.receiver.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public String getStrMessage() throws IOException {
        try {
            if (this.directUnsafe) {
                if (this.first) {
                    this.first = false;
                    return this.receiver.getSyncMessage();
                }
                String string = this.in.readLine();
                return string.substring(2, string.length());
            }
            return this.receiver.getMessage();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.receiver.setAsyncHandler(asyncHandler);
    }

    public void setDirectUnsafeMode(boolean bl) {
        this.directUnsafe = bl;
        this.first = true;
        this.receiver.setDirectUnsafeMode(bl);
    }
}

