/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.PoliqarpIconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class AudioPlayer {
    private JButton speakerButton;
    private JButton playpauseButton;
    private ImageIcon playIcon;
    private ImageIcon pauseIcon;
    private Clip clip;
    private String sampleFilename;
    private static final boolean debug = false;
    private Application app;
    private VoiceLineListener voiceLineListener;

    public AudioPlayer(Application application) {
        this.app = application;
        this.playIcon = PoliqarpIconFactory.loadIconPng("media_start");
        this.pauseIcon = PoliqarpIconFactory.loadIconPng("media_pause");
        ImageIcon imageIcon = PoliqarpIconFactory.loadIconPng("speaker");
        this.speakerButton = new JButton(imageIcon);
        this.playpauseButton = new JButton(this.playIcon);
        this.voiceLineListener = new VoiceLineListener();
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.speakerButton.addActionListener(buttonActionListener);
        this.playpauseButton.addActionListener(buttonActionListener);
        this.speakerButton.setEnabled(false);
        this.playpauseButton.setEnabled(false);
    }

    public void setSample(String string) {
        if (this.sampleFilename == null && string == null || this.sampleFilename != null && string != null && this.sampleFilename.equals(string)) {
            return;
        }
        this.sampleFilename = string;
        if (this.clip != null && this.clip.isRunning()) {
            this.clip.stop();
        }
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.flush();
            this.clip.close();
        }
        this.setButtonsEnabled(this.sampleFilename != null && !this.sampleFilename.isEmpty());
    }

    public JButton getSpeakerButton() {
        return this.speakerButton;
    }

    public JButton getPlaypauseButton() {
        return this.playpauseButton;
    }

    public boolean getButtonsEnabled() {
        if (this.playpauseButton != null) assert (this.speakerButton.isEnabled() == this.playpauseButton.isEnabled());
        return this.speakerButton.isEnabled();
    }

    public void setButtonsEnabled(boolean bl) {
        this.speakerButton.setEnabled(bl);
        if (this.playpauseButton != null) {
            this.playpauseButton.setEnabled(bl);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AudioPlayer.this.speakerButton) {
                // empty if block
            }
            if (actionEvent.getSource() == AudioPlayer.this.playpauseButton) {
                // empty if block
            }
            if (AudioPlayer.this.clip == null || !AudioPlayer.this.clip.isOpen()) {
                try {
                    URL uRL = new File(AudioPlayer.this.sampleFilename).toURI().toURL();
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
                    AudioPlayer.this.clip = AudioSystem.getClip();
                    AudioPlayer.this.clip.addLineListener(AudioPlayer.this.voiceLineListener);
                    AudioPlayer.this.clip.open(audioInputStream);
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    unsupportedAudioFileException.printStackTrace();
                }
                catch (IOException iOException) {
                    AudioPlayer.this.app.showError("NOAUDIOFILE");
                    AudioPlayer.this.clip = null;
                }
                catch (LineUnavailableException lineUnavailableException) {
                    lineUnavailableException.printStackTrace();
                }
            }
            if (actionEvent.getSource() == AudioPlayer.this.speakerButton) {
                if (AudioPlayer.this.clip.isRunning()) {
                    AudioPlayer.this.clip.stop();
                }
                AudioPlayer.this.clip.setFramePosition(0);
                AudioPlayer.this.clip.start();
                if (AudioPlayer.this.playpauseButton != null) {
                    AudioPlayer.this.playpauseButton.setIcon(AudioPlayer.this.pauseIcon);
                }
                return;
            }
            if (actionEvent.getSource() == AudioPlayer.this.playpauseButton) {
                if (AudioPlayer.this.playpauseButton.getIcon() == AudioPlayer.this.playIcon) {
                    if (!AudioPlayer.this.clip.isRunning()) {
                        AudioPlayer.this.clip.start();
                    }
                    AudioPlayer.this.playpauseButton.setIcon(AudioPlayer.this.pauseIcon);
                } else if (AudioPlayer.this.playpauseButton.getIcon() == AudioPlayer.this.pauseIcon) {
                    if (AudioPlayer.this.clip.isRunning()) {
                        AudioPlayer.this.clip.stop();
                    }
                    AudioPlayer.this.playpauseButton.setIcon(AudioPlayer.this.playIcon);
                }
            }
        }
    }

    private class VoiceLineListener
    implements LineListener {
        private VoiceLineListener() {
        }

        public void update(LineEvent lineEvent) {
            if (lineEvent.getType() == LineEvent.Type.STOP) {
                if (AudioPlayer.this.clip.getFramePosition() == AudioPlayer.this.clip.getFrameLength()) {
                    AudioPlayer.this.clip.setFramePosition(0);
                }
                AudioPlayer.this.playpauseButton.setIcon(AudioPlayer.this.playIcon);
            } else if (lineEvent.getType() == LineEvent.Type.START) {
                AudioPlayer.this.playpauseButton.setIcon(AudioPlayer.this.pauseIcon);
            } else if (lineEvent.getType() == LineEvent.Type.OPEN || lineEvent.getType() == LineEvent.Type.CLOSE) {
                // empty if block
            }
        }
    }
}

