/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.util.HotString;
import ipipan.poliqarp.util.PoliqarpUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MultilingualMenuBar
implements MultilingualEntity {
    private JMenuBar menuBar;
    private Set<MenuElement> set;
    private Map<Integer, JMenuItem> map;
    protected Configuration config;

    public MultilingualMenuBar(Configuration configuration) {
        this.config = configuration;
        this.menuBar = new JMenuBar();
        this.set = new HashSet<MenuElement>();
        this.map = new HashMap<Integer, JMenuItem>();
    }

    private void setItemName(JMenuItem jMenuItem, String string) {
        HotString hotString = PoliqarpUtilities.getHotKey(string);
        jMenuItem.setText(hotString.toString());
        if (hotString.isHotKey()) {
            jMenuItem.setMnemonic(hotString.getHotKey());
        }
    }

    public void add(int n, JMenuItem jMenuItem, JMenuItem jMenuItem2) {
        this.setItemName(jMenuItem2, this.config.getMenuComponentName(n));
        this.addAllLang(n, jMenuItem, jMenuItem2);
        this.set.add(new MenuElement(n, jMenuItem2));
    }

    public void addAllLang(int n, JMenuItem jMenuItem, JMenuItem jMenuItem2) {
        jMenuItem2.setActionCommand("" + n);
        this.map.put(n, jMenuItem2);
        if (jMenuItem == null) {
            this.menuBar.add(jMenuItem2);
        } else {
            jMenuItem.add(jMenuItem2);
        }
    }

    public void updateLanguage(Configuration configuration) {
        for (MenuElement menuElement : this.set) {
            this.setItemName(menuElement.item, configuration.getMenuComponentName(menuElement.number));
        }
    }

    public JMenuBar getBar() {
        return this.menuBar;
    }

    public JMenuItem getItem(int n) {
        return this.map.get(n);
    }

    class MenuElement {
        int number;
        JMenuItem item;

        MenuElement(int n, JMenuItem jMenuItem) {
            this.number = n;
            this.item = jMenuItem;
        }
    }
}

