/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.ResultWriter;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.results.ColumnLeftContext;
import ipipan.poliqarp.logic.results.ColumnLeftMatch;
import ipipan.poliqarp.logic.results.ColumnType;
import java.util.Iterator;

public class PlainTxtResultWriter
extends ResultWriter {
    private int[] columnWidth;
    private ColumnType[] header;

    public PlainTxtResultWriter(Configuration configuration) {
        super(configuration);
    }

    private void calculateColumnWidths(Query query) {
        int n;
        this.columnWidth = new int[this.numCols];
        for (n = 0; n < this.numCols; ++n) {
            this.columnWidth[n] = 0;
        }
        Iterator<Match> iterator = query.getMatchList().getIterator();
        while (iterator.hasNext()) {
            Match match = iterator.next();
            for (n = 0; n < this.numCols; ++n) {
                int n2 = match.getCell(n).toString(this.cfg).length();
                if (this.columnWidth[n] >= n2) continue;
                this.columnWidth[n] = n2;
            }
        }
    }

    protected void writeHeader(Query query, String string) {
        this.writer.println(this.cfg.getComponentName("TEXT_RESULTS") + " " + query);
    }

    private void writeField(String string, int n, boolean bl) {
        int n2 = string == null ? 0 : string.length();
        if (!bl & string != null) {
            this.writer.write(string);
        }
        for (int i = n2; i < n; ++i) {
            this.writer.write(32);
        }
        if (bl & string != null) {
            this.writer.write(string);
        }
    }

    protected void writeMatch(Match match) {
        for (int i = 0; i < this.numCols; ++i) {
            boolean bl = this.numCols == 6 ? i > 1 : this.header[i] instanceof ColumnLeftContext || this.header[i] instanceof ColumnLeftMatch;
            this.writeField(match.getCell(i).toString(this.cfg), this.columnWidth[i] + 1, bl);
        }
        this.writer.println();
    }

    protected void writeMatches(Query query) {
        this.calculateColumnWidths(query);
        this.header = query.getHeader();
        super.writeMatches(query);
    }
}

