/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.HelpBrowser;
import ipipan.poliqarp.gui.MultilingualMenuBar;
import ipipan.poliqarp.gui.PoliqarpIconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class PoliqarpMenuBar
extends MultilingualMenuBar
implements ActionListener {
    private static final int M_FILE = 100;
    private static final int M_OPEN = 101;
    private static final int M_MRUMENU = 102;
    private static final int M_MRU = 1020;
    private static final int M_SAVE = 103;
    private static final int M_EXIT = 109;
    private static final int M_QUERYWIZARD = 400;
    private static final int M_QUERYSEGMENTS = 401;
    private static final int M_QUERYMETA = 402;
    private static final int M_QUERYSTAT = 403;
    private static final int M_STATISTICS = 200;
    private static final int M_CORPUSSTATS = 201;
    private static final int M_SETTINGS = 300;
    private static final int M_LANGUAGE = 301;
    private static final int M_ENGLISH = 3011;
    private static final int M_POLISH = 3012;
    private static final int M_OPTIONS = 302;
    private static final int M_CONNECT = 303;
    private static final int M_HELP = 900;
    private static final int M_HELPSEARCH = 901;
    private static final int M_ABOUT = 909;
    private Application app;
    private JMenu recentMenu;

    private JMenuItem createMenuItem(boolean bl) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(Icon icon) {
        JMenuItem jMenuItem = new JMenuItem(icon);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(int n) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 0));
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAccelerator(keyStroke);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(KeyStroke keyStroke, Icon icon, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(icon);
        jMenuItem.setAccelerator(keyStroke);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = Integer.parseInt(jMenuItem.getActionCommand());
        switch (n) {
            case 3011: 
            case 3012: {
                String string = n == 3011 ? "English" : "Polish";
                this.config.setLanguage(string);
                this.app.updateLanguage();
                break;
            }
            case 901: {
                new HelpBrowser(this.app);
                break;
            }
            case 909: {
                this.app.showAbout();
                break;
            }
            case 101: {
                this.app.createOpenDialog();
                break;
            }
            case 103: {
                this.app.createSaveDialog();
                break;
            }
            case 201: {
                this.app.showCorpusStatistics();
                break;
            }
            case 302: {
                this.app.createConfigDialog();
                break;
            }
            case 401: 
            case 402: 
            case 403: {
                this.app.createQueryWizardDialog(n - 400);
                break;
            }
            case 303: {
                this.app.connectToServer();
                break;
            }
            case 109: {
                this.app.exitCleanup();
                System.exit(0);
            }
        }
        if (n >= 1020 && n <= 1029) {
            this.app.openMRU(n - 1020);
        }
    }

    private Icon getJGoodiesIcon(String string) {
        return new ImageIcon(UIManager.getLookAndFeel().getClass().getResource("icons/" + string));
    }

    public void activateCorpusOptions(boolean bl) {
        this.getItem(201).setEnabled(bl);
    }

    public void activateQueryOptions(boolean bl) {
        this.getItem(103).setEnabled(bl);
    }

    public void disableConnectionCmd() {
        this.getItem(303).setEnabled(false);
        this.getItem(101).setEnabled(true);
        this.getItem(102).setEnabled(true);
    }

    public PoliqarpMenuBar(Application application) {
        super(application.getConfig());
        this.app = application;
        String string = "";
        try {
            string = this.config.getConfigItem("language").toLowerCase();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        JMenu jMenu = new JMenu();
        this.add(100, null, jMenu);
        this.add(101, jMenu, this.createMenuItem(KeyStroke.getKeyStroke(79, 2), this.getJGoodiesIcon("TreeOpen.gif"), false));
        this.recentMenu = new JMenu();
        this.recentMenu.setEnabled(false);
        this.add(102, jMenu, this.recentMenu);
        this.add(103, jMenu, this.createMenuItem(KeyStroke.getKeyStroke(83, 2), this.getJGoodiesIcon("FloppyDrive.gif"), false));
        jMenu.addSeparator();
        this.add(109, jMenu, this.createMenuItem(true));
        jMenu = new JMenu();
        this.add(200, null, jMenu);
        this.add(201, jMenu, this.createMenuItem(false));
        jMenu = new JMenu();
        this.add(400, null, jMenu);
        this.add(401, jMenu, this.createMenuItem(true));
        this.add(403, jMenu, this.createMenuItem(true));
        this.add(402, jMenu, this.createMenuItem(true));
        jMenu = new JMenu();
        this.add(300, null, jMenu);
        JMenu jMenu2 = new JMenu();
        this.add(301, jMenu, jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        jRadioButtonMenuItem.setSelected(string.equals("english"));
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.add(3011, jMenu2, jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem();
        jRadioButtonMenuItem.setSelected(string.equals("polish"));
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.add(3012, jMenu2, jRadioButtonMenuItem);
        this.add(302, jMenu, this.createMenuItem(true));
        this.add(303, jMenu, this.createMenuItem(true));
        this.getBar().add(Box.createHorizontalGlue());
        jMenu = new JMenu();
        this.add(900, null, jMenu);
        this.add(901, jMenu, this.createMenuItem(KeyStroke.getKeyStroke(112, 0), null, true));
        jMenu.addSeparator();
        this.add(909, jMenu, this.createMenuItem(null, PoliqarpIconFactory.loadIcon("info"), true));
        this.updateMRU();
    }

    public void updateMRU() {
        int n = 0;
        this.recentMenu.removeAll();
        for (String string : this.config.getMRU()) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke((n + 1) % 10 + 48, 10));
            jMenuItem.addActionListener(this);
            this.addAllLang(1020 + n, this.recentMenu, jMenuItem);
            ++n;
        }
    }
}

