/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MainQueryWizard;
import ipipan.poliqarp.gui.MetaInfoQueryWizard;
import ipipan.poliqarp.gui.QueryWizardItems;
import ipipan.poliqarp.gui.StatQueryWizard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class QueryWizardDialog
extends JDialog {
    private Application app;
    private Configuration cfg;
    private MainQueryWizard mainqueryWizard;
    private StatQueryWizard statqueryWizard;
    private MetaInfoQueryWizard metainfoqueryWizard;
    ActionListener okActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = QueryWizardDialog.this.mainqueryWizard.calculate();
            String string2 = QueryWizardDialog.this.metainfoqueryWizard.calculate();
            String string3 = QueryWizardDialog.this.statqueryWizard.calculate();
            String string4 = string + ' ' + string2 + ' ' + string3;
            ((QueryWizardDialog)QueryWizardDialog.this).app.queryField.setEnabled(true);
            ((QueryWizardDialog)QueryWizardDialog.this).app.queryField.getEditor().setItem(string4);
            ((QueryWizardDialog)QueryWizardDialog.this).app.queryField.requestFocus();
            QueryWizardDialog.this.dispose();
        }
    };

    public QueryWizardDialog(JFrame jFrame, Application application, int n) {
        super(jFrame, application.getConfig().getComponentName("TEXT_QUERY_WIZARD_DIALOG_TITLE"), true);
        this.app = application;
        this.cfg = application.getConfig();
        if (application.getConfig().getConfigItem("language").equalsIgnoreCase("polish")) {
            QueryWizardItems.INSTANCE.setPolishLanguage();
        } else {
            QueryWizardItems.INSTANCE.setEnglishLanguage();
        }
        this.mainqueryWizard = new MainQueryWizard(15, this.okActionListener, this.cfg);
        this.metainfoqueryWizard = new MetaInfoQueryWizard(15, this.okActionListener, this.cfg);
        this.statqueryWizard = new StatQueryWizard(15, this.okActionListener, this.cfg);
        JPanel jPanel = this.createMainPanel(n);
        this.setContentPane(jPanel);
        Dimension dimension = new Dimension(600, 400);
        this.setSize(dimension);
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void launch() {
        this.setVisible(true);
    }

    private JPanel createMainPanel(int n) {
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0);
        RowSpec rowSpec = new RowSpec(Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec(Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec, rowSpec3};
        jPanel.setLayout(new FormLayout(columnSpecArray, rowSpecArray));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(this.cfg.getComponentName("TEXT_QUERY_WIZARD_SEGMENT"), this.mainqueryWizard.contentPanel);
        jTabbedPane.addTab(this.cfg.getComponentName("TEXT_QUERY_WIZARD_METAINFO"), this.metainfoqueryWizard.contentPanel);
        jTabbedPane.addTab(this.cfg.getComponentName("TEXT_QUERY_WIZARD_STATISTIC"), this.statqueryWizard.contentPanel);
        jTabbedPane.setSelectedIndex(n - 1);
        jPanel.add((Component)jTabbedPane, new CellConstraints(1, 1));
        return jPanel;
    }
}

