/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.AudioPlayer;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.ContextArea;
import ipipan.poliqarp.gui.LeftSideCellRenderer;
import ipipan.poliqarp.gui.MetaDataTable;
import ipipan.poliqarp.gui.MultiColorCellRenderer;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.gui.ResultEvent;
import ipipan.poliqarp.gui.ResultEventListener;
import ipipan.poliqarp.gui.ResultModel;
import ipipan.poliqarp.gui.TableCellSizeAdjustor;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResultTable
extends JTable
implements MultilingualEntity,
ResultEventListener,
TableModelListener {
    private ResultModel model;
    private MultiColorCellRenderer mcRenderer;
    private MultiColorCellRenderer lsRenderer;
    private TableCellSizeAdjustor tcsa;
    private boolean contentChanging;
    private Application app;

    public ResultTable(Application application) {
        this.app = application;
        this.model = new ResultModel(application);
        this.setModel(this.model);
        this.tcsa = TableCellSizeAdjustor.adjustorForTable((JTable)this, 1);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
        Color[] colorArray = new Color[]{new Color(192, 255, 192), new Color(255, 255, 255)};
        this.mcRenderer = new MultiColorCellRenderer(colorArray);
        this.lsRenderer = new LeftSideCellRenderer(colorArray);
        this.lsRenderer.setHorizontalAlignment(4);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.model.addResultEventListener(this);
        this.setContentChangingEnabled(true);
    }

    public void setContentChangingEnabled(boolean bl) {
        this.contentChanging = bl;
    }

    public void addContextSelectionListener(ContextArea contextArea, MetaDataTable metaDataTable, AudioPlayer audioPlayer) {
        final ContextArea contextArea2 = contextArea;
        final MetaDataTable metaDataTable2 = metaDataTable;
        final ResultModel resultModel = this.model;
        final AudioPlayer audioPlayer2 = audioPlayer;
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getMinSelectionIndex();
                if (n != -1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < resultModel.getColumnCount(); ++i) {
                        stringBuilder.append(resultModel.getValueAt(n, i));
                    }
                    StringSelection stringSelection = new StringSelection(stringBuilder.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
                if (!ResultTable.this.contentChanging) {
                    return;
                }
                if (n == -1) {
                    contextArea2.wipe();
                    metaDataTable2.getModel().setSource(ResultTable.this.app.getCorpus(), null);
                    if (audioPlayer2 != null) {
                        audioPlayer2.setSample(null);
                    }
                } else {
                    ResultTable.this.model.setAreaContent(contextArea2, metaDataTable2, n, audioPlayer2);
                }
            }
        });
    }

    private void updateRenderer() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(this.mcRenderer);
        }
    }

    public void updateLanguage(Configuration configuration) {
        this.tcsa.setEnabled(false);
        this.model.setColumnNames(configuration);
        this.updateRenderer();
        this.tcsa.setEnabled(true);
    }

    public ResultModel getModel() {
        return this.model;
    }

    public void resultChanged(ResultEvent resultEvent) {
        if (resultEvent.tableChanged()) {
            this.updateLanguage(resultEvent.getConfig());
        }
    }
}

