/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MultifunctionButton;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.gui.PoliqarpIconFactory;
import ipipan.poliqarp.gui.ResultEvent;
import ipipan.poliqarp.gui.ResultEventListener;
import ipipan.poliqarp.gui.ResultModel;
import ipipan.poliqarp.gui.StatusLine;
import ipipan.poliqarp.logic.Job;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class StatusPanel
extends JPanel
implements MultilingualEntity,
ResultEventListener {
    private Application app;
    private StatusLine statusLine;
    private JProgressBar progressBar;
    private MultifunctionButton toggleButton;
    private JButton upButton;
    private JButton downButton;
    private Timer timer;
    private ResultModel res;
    private boolean upLast;
    private boolean downLast;
    private JButton speakerButton;
    private JButton playpauseButton;

    public StatusPanel(Application application) {
        this.app = application;
        this.timer = null;
        this.setLayout(new FormLayout("0:grow(0.65), 2dlu, 0:grow(0.35), 2dlu, default, 2dlu, default, 2dlu, default, 2dlu, default, 2dlu, default", "default"));
        this.statusLine = new StatusLine();
        this.add((Component)this.statusLine, new CellConstraints(1, 1));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        this.add((Component)this.progressBar, new CellConstraints(3, 1));
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.toggleButton = new MultifunctionButton("TOGGLE", 2);
        this.toggleButton.addActionListener(buttonActionListener);
        this.add((Component)this.toggleButton, new CellConstraints(5, 1));
        this.upButton = new JButton(PoliqarpIconFactory.loadIcon("arr_u"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(buttonActionListener);
        this.add((Component)this.upButton, new CellConstraints(7, 1));
        this.downButton = new JButton(PoliqarpIconFactory.loadIcon("arr_d"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(buttonActionListener);
        this.add((Component)this.downButton, new CellConstraints(9, 1));
        this.speakerButton = application.getAudioPlayer().getSpeakerButton();
        this.add((Component)this.speakerButton, new CellConstraints(11, 1));
        this.playpauseButton = application.getAudioPlayer().getPlaypauseButton();
        this.add((Component)this.playpauseButton, new CellConstraints(13, 1));
    }

    public void updateLanguage(Configuration configuration) {
        this.statusLine.updateLanguage(configuration);
        this.toggleButton.updateLanguage(configuration);
    }

    public void enableProgress(Job job) {
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.timer = new Timer(100, new ProgressBarListener(job, this.progressBar));
        this.timer.start();
    }

    public void disableProgress() {
        this.timer.stop();
        this.timer = null;
        this.progressBar.setVisible(false);
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setState(StatusLine.State state, String string, String string2, Configuration configuration) {
        this.statusLine.setState(state, string, string2);
        this.statusLine.updateLanguage(configuration);
    }

    public void resultChanged(ResultEvent resultEvent) {
        this.res = resultEvent.getSource();
        this.upButton.setEnabled(this.res.getStartPosition() > 0);
        this.downButton.setEnabled(this.res.getEndPosition() < this.res.getTotal());
        this.statusLine.resultChanged(resultEvent);
    }

    public void setButtonsEnabled(boolean bl) {
        if (bl) {
            this.upButton.setEnabled(this.upLast);
            this.downButton.setEnabled(this.downLast);
        } else {
            this.upLast = this.upButton.isEnabled();
            this.downLast = this.downButton.isEnabled();
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private final class ProgressBarListener
    implements ActionListener {
        private Job job;
        private JProgressBar bar;

        public ProgressBarListener(Job job, JProgressBar jProgressBar) {
            this.job = job;
            this.bar = jProgressBar;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.bar.setValue(this.job.getProgress());
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == StatusPanel.this.upButton) {
                StatusPanel.this.res.scrollUp();
            } else if (actionEvent.getSource() == StatusPanel.this.downButton) {
                StatusPanel.this.res.scrollDown();
            } else if (actionEvent.getSource() == StatusPanel.this.toggleButton) {
                StatusPanel.this.toggleButton.nextFunction();
                StatusPanel.this.app.toggleContextVisible();
            }
        }
    }
}

