/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class TableCellSizeAdjustor
implements TableModelListener,
TableColumnModelListener {
    public static final boolean debug = false;
    public static final int ADJUST_WIDTH = 1;
    public static final int ADJUST_HEIGHT = 2;
    public static final int ADJUST_BOTH = 3;
    private static final int RESIZECOMPLETELY = 0;
    private static final int SETHEIGHT = 1;
    private static final int SETWIDTH = 2;
    private static final int SETBOTH = 3;
    private static final int DONOTHING = 4;
    private JTable jt;
    private TableModel tm;
    private TableColumnModel tcm;
    private boolean adjustwidth;
    private boolean adjustheight;
    private boolean toggleadjust;
    private boolean adjustbyeditor;
    private boolean enabled;
    private boolean postponeadjustment;
    private int[] maxwidth;
    private int[] maxwidthidx;
    private int[] maxheight;
    private int[] maxheightidx;
    private TableColumn[] tablecolumn;
    private int maxrow;
    private int allmaxheight;
    private int columncount;
    private boolean recalccompletely;
    private List ajis;
    private int divident;
    private int divisor;
    private TableCellRenderer headerrenderer;

    public static TableCellSizeAdjustor adjustorForTable(JTable jTable) {
        return new TableCellSizeAdjustor(jTable, 3, false);
    }

    public static TableCellSizeAdjustor adjustorForTable(JTable jTable, int n) {
        return new TableCellSizeAdjustor(jTable, n, false);
    }

    public static TableCellSizeAdjustor adjustorForTable(JTable jTable, boolean bl) {
        return new TableCellSizeAdjustor(jTable, 3, bl);
    }

    public static TableCellSizeAdjustor adjustorForTable(JTable jTable, int n, boolean bl) {
        return new TableCellSizeAdjustor(jTable, n, bl);
    }

    private TableCellSizeAdjustor(JTable jTable, int n, boolean bl) {
        this.jt = jTable;
        this.jt.setAutoResizeMode(0);
        this.tm = this.jt.getModel();
        this.tcm = this.jt.getColumnModel();
        this.tm.addTableModelListener(this);
        this.tcm.addColumnModelListener(this);
        this.adjustwidth = n == 1 || n == 3;
        this.adjustheight = n == 2 || n == 3;
        this.toggleadjust = true;
        this.adjustbyeditor = bl;
        this.ajis = new ArrayList();
        this.divident = 3;
        this.divisor = 4;
        this.recalccompletely = true;
        this.maxrow = 0;
        this.enabled = true;
        this.postponeadjustment = false;
        this.headerrenderer = new JTableHeader().getDefaultRenderer();
    }

    public void reBindListeners() {
        TableModel tableModel = this.jt.getModel();
        TableColumnModel tableColumnModel = this.jt.getColumnModel();
        if (tableModel != this.tm) {
            this.tm.removeTableModelListener(this);
            this.tm = tableModel;
            this.tm.addTableModelListener(this);
            this.recalccompletely = true;
        }
        if (tableColumnModel != this.tcm) {
            this.tcm.removeColumnModelListener(this);
            this.tcm = tableColumnModel;
            this.tcm.addColumnModelListener(this);
            this.recalccompletely = true;
        }
    }

    public void setReadjustFraction(int n, int n2) {
        this.divident = n;
        this.divisor = n2;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!this.recalccompletely) {
            switch (tableModelEvent.getType()) {
                case 0: {
                    if (tableModelEvent.getColumn() == -1 && (tableModelEvent.getFirstRow() == -1 && tableModelEvent.getLastRow() == -1 || tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE) || this.tm.getRowCount() != this.maxrow) {
                        this.recalccompletely = true;
                        this.ajis.clear();
                        break;
                    }
                    this.insertAJI(new AdjustmentInstruction(tableModelEvent.getFirstRow(), Math.min(this.maxrow, tableModelEvent.getLastRow()), tableModelEvent.getColumn()));
                    break;
                }
                case 1: {
                    this.maxrow += tableModelEvent.getLastRow() - tableModelEvent.getFirstRow();
                    if (tableModelEvent.getFirstRow() < this.maxrow) {
                        this.shiftIndices(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow() - tableModelEvent.getFirstRow());
                    }
                    this.insertAJI(new AdjustmentInstruction(tableModelEvent.getFirstRow() + 1, tableModelEvent.getLastRow(), tableModelEvent.getColumn()));
                    break;
                }
                case -1: {
                    this.maxrow -= tableModelEvent.getLastRow() - tableModelEvent.getFirstRow();
                    this.shiftIndices(tableModelEvent.getFirstRow(), tableModelEvent.getFirstRow() - tableModelEvent.getLastRow());
                }
            }
        }
        this.toggleAdjustment();
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.recalccompletely = true;
        this.toggleAdjustment();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.recalccompletely = true;
        this.toggleAdjustment();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void toggleAdjustment() {
        if (this.toggleadjust) {
            this.toggleadjust = false;
            if (this.enabled) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TableCellSizeAdjustor.this.runAdjustment();
                    }
                });
            } else {
                this.postponeadjustment = true;
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        if (this.enabled) {
            if (this.postponeadjustment) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TableCellSizeAdjustor.this.runAdjustment();
                    }
                });
            }
        } else {
            this.postponeadjustment = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void shiftIndices(int n, int n2) {
        for (int i = 0; i < this.columncount; ++i) {
            if (this.maxwidthidx[i] <= n) continue;
            if (n2 < 0 && this.maxwidthidx[i] < n - n2) {
                this.maxwidthidx[i] = -1;
                this.maxwidth[i] = -1;
                this.insertAJI(new AdjustmentInstruction(0, this.maxrow, i));
                continue;
            }
            int n3 = i;
            this.maxwidthidx[n3] = this.maxwidthidx[n3] + n2;
        }
    }

    private void insertAJI(AdjustmentInstruction adjustmentInstruction) {
        for (int i = 0; i < this.ajis.size(); ++i) {
            if (!((AdjustmentInstruction)this.ajis.get(i)).combine(adjustmentInstruction)) continue;
            return;
        }
        this.ajis.add(adjustmentInstruction);
    }

    private void runAdjustment() {
        int n;
        if (this.recalccompletely) {
            this.initArrays();
            for (n = 0; n < this.columncount; ++n) {
                this.finishSingleAdjustment(0, n);
            }
        } else {
            for (n = 0; n < this.ajis.size(); ++n) {
                AdjustmentInstruction adjustmentInstruction = (AdjustmentInstruction)this.ajis.get(n);
                if (adjustmentInstruction.column == -1) {
                    for (int i = 0; i < this.columncount; ++i) {
                        this.finishSingleAdjustment(this.adjustColumnPart(adjustmentInstruction.firstrow, adjustmentInstruction.lastrow, i), i);
                    }
                    continue;
                }
                this.finishSingleAdjustment(this.adjustColumnPart(adjustmentInstruction.firstrow, adjustmentInstruction.lastrow, adjustmentInstruction.column), adjustmentInstruction.column);
            }
        }
        JTableHeader jTableHeader = this.jt.getTableHeader();
        this.jt.invalidate();
        jTableHeader.invalidate();
        this.jt.repaint();
        jTableHeader.repaint();
        this.toggleadjust = true;
        this.recalccompletely = false;
        this.ajis.clear();
    }

    private void finishSingleAdjustment(int n, int n2) {
        if (n == 0) {
            n = this.adjustCompleteColumn(n2);
        }
        if (this.adjustwidth && (n == 2 || n == 3)) {
            try {
                this.tablecolumn[n2].setWidth(this.maxwidth[n2] + 6);
                this.tablecolumn[n2].setPreferredWidth(this.maxwidth[n2] + 6);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.adjustheight && (n == 1 || n == 3) && this.collectHeights() == 1) {
            this.jt.setRowHeight(this.allmaxheight);
        }
    }

    private int collectHeights() {
        int n = this.allmaxheight;
        for (int i = 0; i < this.columncount; ++i) {
            this.allmaxheight = Math.max(this.allmaxheight, this.maxheight[i]);
        }
        return n < this.allmaxheight ? 1 : 4;
    }

    private void initArrays() {
        this.columncount = this.tm.getColumnCount();
        this.maxwidth = new int[this.columncount];
        this.maxheight = new int[this.columncount];
        this.maxwidthidx = new int[this.columncount];
        this.maxheightidx = new int[this.columncount];
        this.tablecolumn = new TableColumn[this.columncount];
        for (int i = 0; i < this.columncount; ++i) {
            try {
                this.tablecolumn[i] = this.jt.getColumnModel().getColumn(i);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.allmaxheight = 4;
    }

    private int adjustCompleteColumn(int n) {
        this.maxwidth[n] = 4;
        this.maxheight[n] = 4;
        this.maxwidthidx[n] = -10;
        this.maxheightidx[n] = -10;
        this.adjustColumnPart(-1, this.jt.getRowCount() - 1, n);
        return 3;
    }

    private int adjustColumnPart(int n, int n2, int n3) {
        try {
            boolean bl;
            int n4;
            int n5;
            boolean bl2 = false;
            if (n == -1) {
                TableCellRenderer tableCellRenderer = this.tablecolumn[n3].getHeaderRenderer();
                if (tableCellRenderer == null && this.headerrenderer != null) {
                    tableCellRenderer = this.headerrenderer;
                    this.tablecolumn[n3].setHeaderRenderer(tableCellRenderer);
                }
                if (tableCellRenderer != null) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.jt, this.tm.getColumnName(n3), false, false, -1, n3);
                    int n6 = n5 = component == null ? 0 : component.getPreferredSize().width;
                    if (n5 > this.maxwidth[n3]) {
                        this.maxwidth[n3] = n5;
                        bl2 = true;
                    }
                }
                if (n2 == -1) {
                    return bl2 ? 2 : 4;
                }
                n = 0;
            }
            int n7 = this.maxwidth[n3];
            int n8 = this.maxheight[n3];
            n5 = n7;
            int n9 = n8;
            int n10 = this.maxwidthidx[n3];
            int n11 = this.maxheightidx[n3];
            TableCellRenderer tableCellRenderer = null;
            TableCellEditor tableCellEditor = null;
            for (n4 = n; n4 <= n2; ++n4) {
                try {
                    if (this.adjustbyeditor) {
                        tableCellEditor = this.jt.getCellEditor(n4, n3);
                    } else {
                        tableCellRenderer = this.jt.getCellRenderer(n4, n3);
                    }
                    Object object = this.tm.getValueAt(n4, n3);
                    Dimension dimension = (this.adjustbyeditor ? tableCellEditor.getTableCellEditorComponent(this.jt, object, false, n4, n3) : tableCellRenderer.getTableCellRendererComponent(this.jt, object, false, false, n4, n3)).getPreferredSize();
                    if (n4 == n10 && dimension.width * this.divisor < n7 * this.divident) {
                        return 0;
                    }
                    if (n4 == n11 && dimension.height * this.divisor < n8 * this.divident) {
                        return 0;
                    }
                    if (dimension.width > n7) {
                        n7 = dimension.width;
                        n10 = n4;
                    }
                    if (dimension.height <= n8) continue;
                    n8 = dimension.height;
                    n11 = n4;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            n4 = n7 != n5 || bl2 ? 1 : 0;
            boolean bl3 = bl = n8 != n9;
            if (n4 != 0) {
                this.maxwidth[n3] = n7;
                this.maxwidthidx[n3] = n10;
            }
            if (bl) {
                this.maxheight[n3] = n8;
                this.maxheightidx[n3] = n11;
            }
            return n4 != 0 ? (bl ? 3 : 2) : (bl ? 1 : 4);
        }
        catch (NullPointerException nullPointerException) {
            return 4;
        }
    }

    class AdjustmentInstruction {
        public int firstrow;
        public int lastrow;
        public int column;

        public AdjustmentInstruction(int n, int n2, int n3) {
            this.firstrow = n;
            this.lastrow = n2;
            this.column = n3;
        }

        public boolean equals(AdjustmentInstruction adjustmentInstruction) {
            return this.firstrow == adjustmentInstruction.firstrow && this.lastrow == adjustmentInstruction.lastrow && this.column == adjustmentInstruction.column;
        }

        public boolean combine(AdjustmentInstruction adjustmentInstruction) {
            if (adjustmentInstruction.column == this.column) {
                if (adjustmentInstruction.firstrow >= this.firstrow && adjustmentInstruction.lastrow <= this.lastrow) {
                    return true;
                }
                if (adjustmentInstruction.firstrow <= this.firstrow && adjustmentInstruction.lastrow >= this.lastrow) {
                    this.firstrow = adjustmentInstruction.firstrow;
                    this.lastrow = adjustmentInstruction.lastrow;
                    return true;
                }
                if (adjustmentInstruction.firstrow <= this.lastrow + 1 && adjustmentInstruction.lastrow >= this.lastrow) {
                    this.lastrow = adjustmentInstruction.lastrow;
                    return true;
                }
                if (adjustmentInstruction.firstrow <= this.firstrow && adjustmentInstruction.lastrow >= this.firstrow - 1) {
                    this.firstrow = adjustmentInstruction.firstrow;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "<AdjustmentInstruction: 1st row: " + this.firstrow + ", last row: " + this.lastrow + ", column: " + (this.column == -1 ? "ALL" : Integer.toString(this.column)) + ">";
        }
    }
}

