/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.stat.CTest;
import ipipan.poliqarp.stat.StatCell;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MatchCount {
    private MatchCount left;
    private MatchCount right;
    private String match;
    private int count;
    private float cp = 0.0f;
    private boolean cpCalc = false;
    private int matchRef;
    private static final NumberFormat format = new DecimalFormat("0.000");
    private static final StatCell emptyCell = new StatCell("");

    public MatchCount(String string, int n) {
        this.left = null;
        this.right = null;
        this.count = 1;
        this.match = string;
        this.matchRef = n;
    }

    public MatchCount(String string, MatchCount matchCount, MatchCount matchCount2, int n) {
        this.left = matchCount;
        this.right = matchCount2;
        this.count = 1;
        this.match = string;
        this.matchRef = n;
    }

    public void inc() {
        ++this.count;
    }

    public String getMatch() {
        return this.match;
    }

    public int getMatchRef() {
        return this.matchRef;
    }

    public float getCp(CTest cTest) {
        if (this.cpCalc || this.left == null) {
            return this.cp;
        }
        this.cp = cTest.calc(this.left.count, this.right.count, this.count);
        this.cpCalc = true;
        return this.cp;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        String string = this.count + "\t" + this.match;
        if (this.left != null) {
            string = this.left.getCount() + "\t" + this.right.getCount() + "\t" + string;
        }
        if (this.cpCalc) {
            string = format.format(this.cp) + "\t" + string;
        }
        return string;
    }

    public String[] toStringArray() {
        String[] stringArray = null;
        if (this.left == null) {
            stringArray = new String[]{this.match, String.valueOf(this.getCount())};
            return stringArray;
        }
        stringArray = new String[this.cpCalc ? 6 : 5];
        stringArray[0] = this.left.getMatch();
        stringArray[1] = this.right.getMatch();
        stringArray[2] = String.valueOf(this.left.getCount());
        stringArray[3] = String.valueOf(this.right.getCount());
        stringArray[4] = String.valueOf(this.getCount());
        if (this.cpCalc) {
            stringArray[5] = format.format(this.cp);
        }
        return stringArray;
    }

    public StatCell[] toCellArray() {
        StatCell[] statCellArray = null;
        if (this.left == null) {
            statCellArray = new StatCell[]{new StatCell(this.match), new StatCell(this.getCount())};
            return statCellArray;
        }
        statCellArray = new StatCell[this.cpCalc ? 6 : 5];
        statCellArray[0] = new StatCell(this.left.getMatch());
        statCellArray[1] = new StatCell(this.right.getMatch());
        statCellArray[2] = new StatCell(this.left.getCount());
        statCellArray[3] = new StatCell(this.right.getCount());
        statCellArray[4] = new StatCell(this.getCount());
        if (this.cpCalc) {
            statCellArray[5] = new StatCell(this.cp);
        }
        return statCellArray;
    }
}

