/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.logic.Interpretation;
import ipipan.poliqarp.logic.Segment;
import ipipan.poliqarp.stat.StatQueryException;
import ipipan.poliqarp.stat.Tagset;
import ipipan.poliqarp.stat.Util;

public class SelectorPart {
    static final int BY_ORTH = 1;
    static final int BY_BASE = 2;
    static final int BY_OLEN = 3;
    static final int BY_CTAG = 4;
    static final int REQ_ORTH = 1;
    static final int REQ_LEMM = 2;
    static final int REQ_TAGS = 4;
    int segno;
    int type;
    String attr;
    Tagset tagset;
    int requirements;

    public SelectorPart(String string, Tagset tagset) throws StatQueryException {
        this.tagset = tagset;
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 2) {
            // empty if block
        }
        if (stringArray.length == 2) {
            this.segno = Util.safeParseInt(stringArray[0], 1);
            if (this.segno == 0) {
                this.segno = 1;
            }
            this.setType(stringArray[1]);
        } else {
            this.segno = 1;
            this.setType(stringArray[0]);
        }
    }

    void setType(String string) throws StatQueryException {
        if (string.equalsIgnoreCase("orth")) {
            this.type = 1;
            this.requirements = 1;
            return;
        }
        if (string.equalsIgnoreCase("length")) {
            this.type = 3;
            this.requirements = 1;
            return;
        }
        if (string.equalsIgnoreCase("base")) {
            this.type = 2;
            this.requirements = 2;
            return;
        }
        this.type = 4;
        this.requirements = 4;
        this.attr = this.tagset.getBaseName(string);
        if (this.attr == null) {
            System.err.println("SelectorPart.setType(): <" + string + "> not in tagset>");
            throw new StatQueryException();
        }
    }

    public int getSegno() {
        return this.segno;
    }

    public int getRequirements() {
        return this.requirements;
    }

    public String orthValue(Segment segment) {
        if (this.type == 1) {
            return segment.getOrth().toLowerCase().trim();
        }
        if (this.type == 3) {
            return String.valueOf(segment.getOrth().trim().length());
        }
        return null;
    }

    public String tagValue(Interpretation interpretation) {
        if (this.type == 1) {
            return null;
        }
        if (this.type == 2) {
            return interpretation.getLemma();
        }
        return this.tagset.getAttrValue(interpretation.getTag(), this.attr);
    }
}

