/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.actions;

import ipipan.spejd.actions.Action;
import ipipan.spejd.entities.Entity;
import ipipan.spejd.rules.Match;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.Util;
import java.util.Set;
import java.util.regex.Pattern;

public class AgreeAction
extends Action {
    int[] segs;
    int[] attr;
    boolean unify;

    AgreeAction(boolean unify, int[] attr, int[] segs, Config conf) {
        super(conf);
        this.unify = unify;
        this.attr = attr;
        this.segs = segs;
    }

    @Override
    public int[] required() {
        return this.segs;
    }

    public Set<String> getCommonValues(Entity[] match, int[] attrIds) {
        Set<String> values = match[0].getAttrValues(attrIds, this.conf.nullAgreement);
        int i = 1;
        while (i < match.length) {
            values.retainAll(match[i].getAttrValues(attrIds, this.conf.nullAgreement));
            ++i;
        }
        return values;
    }

    public boolean unify(Entity[] match, int[] attrIds) {
        Set<String> values = this.getCommonValues(match, attrIds);
        if (values.size() == 0) {
            return false;
        }
        Util ut = new Util(this.conf);
        Pattern pattern = Pattern.compile(String.valueOf(ut.join("[^<>]+|", values)) + "[^<>]+");
        int i = 0;
        while (i < match.length) {
            match[i].delete(pattern, true);
            ++i;
        }
        return true;
    }

    @Override
    public boolean apply(Match matcher) {
        Entity[] match = matcher.get(this.segs);
        if (match.length == 0) {
            return true;
        }
        return this.unify ? this.unify(match, this.attr) : this.getCommonValues(match, this.attr).size() > 0;
    }

    public String toString() {
        return String.valueOf(this.unify ? "unify" : "agree") + " segs: " + this.intArgs(this.segs) + "attr: " + this.intArgs(this.attr);
    }
}

