/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.actions;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.rules.Match;

public class WordBasePart {
    static final int CONC = -1;
    static final int TEXT = -2;
    static final int THIS = -3;
    int segno;
    int attrid;
    String text;

    public WordBasePart() {
        this.segno = -3;
        this.attrid = 1;
    }

    public WordBasePart(String text) {
        this.segno = -2;
        this.text = text;
    }

    public WordBasePart(int segno, int attrid) {
        this.segno = segno - 1;
        this.attrid = attrid;
    }

    public String concatAttr(int id, Entity[] s, int start, int end) {
        StringBuilder res = new StringBuilder();
        boolean nospace = true;
        int i = start;
        while (i < end) {
            if (s[i].type == 'n') {
                nospace = true;
            } else {
                if (!nospace) {
                    res.append(' ');
                }
                res.append(s[i].getAttr(id));
                nospace = false;
            }
            ++i;
        }
        return res.toString();
    }

    public String concatAttr(int id, Entity[] s) {
        return this.concatAttr(id, s, 0, s.length);
    }

    public String eval(Match matcher) {
        if (this.segno == -2) {
            return this.text;
        }
        if (this.segno == -3) {
            return "%";
        }
        Entity[] e = this.segno == -1 ? matcher.getMatch() : matcher.getSpec(this.segno);
        return this.concatAttr(this.attrid, e);
    }

    public String toString() {
        if (this.segno == -2) {
            return this.text;
        }
        if (this.segno == -1) {
            return "all." + this.attrid;
        }
        if (this.segno == -3) {
            return "this." + this.attrid;
        }
        return String.valueOf(this.segno) + "." + this.attrid;
    }
}

