/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.entities;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Segment;
import ipipan.spejd.processing.ProcessingThread;
import ipipan.spejd.util.Config;
import java.io.PrintStream;
import java.util.Set;
import java.util.regex.Pattern;

public class Group
extends Entity {
    String groupType;
    Entity[] content;
    Segment synh;
    Segment semh;
    boolean oneh;

    public Group(String type, Entity synh, Entity semh, Entity[] match, Config conf) {
        super(conf);
        this.id = ((ProcessingThread)Thread.currentThread()).chunk.getNewId();
        this.content = match;
        this.groupType = type;
        this.synh = synh.getSynHead();
        this.semh = semh.getSemHead();
        this.oneh = synh == semh;
        this.modified = true;
    }

    @Override
    public String getAttr(int id) {
        return this.concatAttr(id, this.content);
    }

    @Override
    public Segment getSynHead() {
        return this.synh;
    }

    @Override
    public Segment getSemHead() {
        return this.semh;
    }

    @Override
    public String getGroupType() {
        return this.groupType;
    }

    @Override
    public Set<String> getAttrValues(int[] attrIds, boolean acceptNull) {
        return this.synh.getAttrValues(attrIds, acceptNull);
    }

    @Override
    public void delete(Pattern pattern, boolean neg) {
        this.synh.delete(pattern, neg);
        this.modified = this.modified || this.synh.modified;
    }

    @Override
    void updateTxt() {
        StringBuilder res = new StringBuilder();
        res.append("<<g<");
        res.append(this.id);
        res.append('<');
        res.append(this.oneh ? 1 : 2);
        res.append('<');
        res.append(this.groupType);
        res.append('>');
        int lastl = res.length();
        int i = 0;
        while (i < this.synh.interp.length) {
            this.synh.interp[i].printTxt(res);
            ++i;
        }
        if (res.length() == lastl) {
            res.append("<");
            i = 0;
            while (i < this.conf.tagset.nOfAttributes() - 2) {
                res.append("0");
                ++i;
            }
        }
        res.append('>');
        lastl = res.length();
        i = 0;
        while (i < this.semh.interp.length) {
            this.semh.interp[i].printTxt(res);
            ++i;
        }
        if (res.length() == lastl) {
            res.append("<");
            i = 0;
            while (i < this.conf.tagset.nOfAttributes() - 2) {
                res.append("0");
                ++i;
            }
        }
        res.append('>');
        this.text = res.toString();
        this.modified = false;
    }

    @Override
    public void printXML(PrintStream out) {
        out.print("<group id=\"");
        out.print(this.id);
        if (this.rule != null) {
            out.print("\" rule=\"");
            out.print(this.rule.getTitle());
        }
        out.print("\" synh=\"");
        out.print(this.synh.id);
        out.print("\" semh=\"");
        out.print(this.semh.id);
        out.print("\" type=\"");
        out.print(this.groupType);
        out.print("\">\n");
        int i = 0;
        while (i < this.content.length) {
            this.content[i].printXML(out);
            ++i;
        }
        out.println("</group>");
    }
}

