/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.processing;

import ipipan.spejd.processing.ProcessingThread;
import ipipan.spejd.rules.LexDictionary;
import ipipan.spejd.rules.RuleSet;
import ipipan.spejd.rules.Sentence;
import ipipan.spejd.util.Config;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import morfologik.stemmers.Stempelator;

public class ProcessingThreadsFactory
implements ThreadFactory {
    private Stempelator stemmer = null;
    private final Config conf;
    private final Object lock;

    public ProcessingThreadsFactory(Object lock, Config conf) {
        this.lock = lock;
        this.conf = conf;
    }

    @Override
    public ProcessingThread newThread(Runnable r) {
        try {
            this.stemmer = new Stempelator();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        RuleSet rules = new RuleSet(this.conf);
        LexDictionary dict = new LexDictionary(this.conf.lexDictionaries, this.conf);
        Sentence chunk = new Sentence(this.conf, dict, this.stemmer);
        return new ProcessingThread(r, this.stemmer, dict, rules, chunk, this.conf, this.lock);
    }
}

