/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.ruleparser;

import ipipan.spejd.ruleparser.AltRequirement;
import ipipan.spejd.ruleparser.EntityRequirement;
import ipipan.spejd.ruleparser.GroupRequirement;
import ipipan.spejd.ruleparser.Requirement;
import ipipan.spejd.ruleparser.SequenceRequirement;
import ipipan.spejd.ruleparser.SpecialRequirement;
import ipipan.spejd.ruleparser.TokenRequirement;
import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class MatchParser {
    String line;
    int currentChar;
    int currentLine;
    BufferedReader in;
    Map<String, EntityRequirement> macros;
    protected Config conf = null;
    static final String eqOperators = "!~";

    public MatchParser(Config conf) {
        this.conf = conf;
        this.macros = new TreeMap<String, EntityRequirement>();
        this.line = "";
        this.currentLine = 0;
        this.currentChar = 0;
    }

    public MatchParser(BufferedReader in, Config conf) {
        this(conf);
        this.in = in;
        this.eatWhite();
    }

    protected boolean feed() {
        try {
            this.line = this.in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        ++this.currentLine;
        if (this.line == null) {
            return false;
        }
        this.line = " " + this.line + " ";
        this.currentChar = 0;
        return true;
    }

    protected char currentChar() {
        return this.line.charAt(this.currentChar);
    }

    protected boolean charsLeft() {
        if (this.line == null) {
            return false;
        }
        if (this.currentChar < this.line.length()) {
            return true;
        }
        return this.feed();
    }

    protected boolean currentCharIs(char c) {
        if (!this.charsLeft()) {
            return false;
        }
        return this.currentChar() == c;
    }

    protected boolean currentCharNot(char c) {
        if (!this.charsLeft()) {
            return false;
        }
        return this.currentChar() != c;
    }

    protected boolean currentCharIsDigit() {
        if (!this.charsLeft()) {
            return false;
        }
        return Character.isDigit(this.currentChar());
    }

    protected boolean currentCharIsIn(String set) {
        if (!this.charsLeft()) {
            return false;
        }
        return set.indexOf(this.currentChar()) >= 0;
    }

    protected boolean currentCharNotIn(String set) {
        if (!this.charsLeft()) {
            return false;
        }
        return set.indexOf(this.currentChar()) < 0;
    }

    protected void error(String desc) {
        System.err.println("    Error at line " + this.currentLine + ", char " + this.currentChar);
        System.err.println(this.line);
        int i = 0;
        while (i < this.currentChar) {
            System.err.print(" ");
            ++i;
        }
        System.err.println("^");
        System.err.println("    " + desc + ".");
        System.exit(1);
    }

    protected void eatWhite() {
        while (this.charsLeft()) {
            if (Character.isWhitespace(this.currentChar())) {
                ++this.currentChar;
                continue;
            }
            if (this.currentChar() != '#') break;
            this.feed();
        }
    }

    protected boolean preview(String expected) {
        if (!this.charsLeft()) {
            return false;
        }
        return this.line.substring(this.currentChar).startsWith(expected);
    }

    protected boolean eat(String expected, boolean eatWhite) {
        if (this.preview(expected)) {
            this.currentChar += expected.length();
            if (eatWhite) {
                this.eatWhite();
            }
            return true;
        }
        return false;
    }

    protected void forceEat(String expected, boolean eatWhite) {
        if (!this.eat(expected, eatWhite)) {
            this.error("'" + expected + "' expected");
        }
    }

    protected String readWord(String nonLetterChars, boolean allowEmpty) {
        this.eatWhite();
        if (nonLetterChars == null) {
            nonLetterChars = "";
        }
        int start = this.currentChar;
        String res = this.line.substring(start);
        while (this.charsLeft() && (Character.isLetterOrDigit(this.currentChar()) || this.currentCharIsIn(nonLetterChars))) {
            ++this.currentChar;
        }
        if (!allowEmpty && this.currentChar == start) {
            this.error("Alphanumeric characters expected");
        }
        if (this.currentChar >= start) {
            res = this.line.substring(start, this.currentChar);
        }
        this.eatWhite();
        return res;
    }

    protected String readId() {
        return this.readWord("_-", false);
    }

    protected int readAttrId() {
        String attr = this.readId();
        int attrId = this.conf.tagset.attrToInt(attr);
        if (attrId < 0) {
            this.error("Unknown attribute: " + attr);
        }
        return attrId;
    }

    protected String readTag() {
        return this.readWord("_-:.*", true);
    }

    protected String readFilename() {
        String res = this.readWord("_-./\\", false);
        if (!new File(res).exists()) {
            this.error("File not found: " + res);
        }
        this.eatWhite();
        return res;
    }

    protected String readRegexp() {
        this.forceEat("\"", false);
        int start = this.currentChar;
        while (this.currentCharNot('\"')) {
            if (this.currentChar() == '\\') {
                ++this.currentChar;
            }
            ++this.currentChar;
            if (this.currentChar != 1) continue;
            this.error("Unmatched \" or illegal line break inside an expresion.");
        }
        String res = this.line.substring(start, this.currentChar);
        this.forceEat("\"", true);
        return res;
    }

    protected String readString() {
        if (this.currentCharIs('\"')) {
            return this.readRegexp();
        }
        return this.readId();
    }

    protected int readFlags() {
        if (!this.eat("/", false)) {
            return 0;
        }
        int res = 0;
        while (this.charsLeft() && Character.isLetter(this.currentChar())) {
            switch (this.currentChar()) {
                case 'i': {
                    res |= 4;
                    break;
                }
                case 'x': {
                    res |= 8;
                    break;
                }
                default: {
                    this.error("Unknown flag: " + this.currentChar());
                }
            }
            ++this.currentChar;
        }
        this.eatWhite();
        return res;
    }

    protected int readNumber(boolean eatWhite) {
        int start = this.currentChar;
        while (this.currentCharIsDigit()) {
            ++this.currentChar;
        }
        if (this.currentChar == start) {
            this.error("Number expected");
        }
        int res = Integer.parseInt(this.line.substring(start, this.currentChar));
        if (eatWhite) {
            this.eatWhite();
        }
        return res;
    }

    protected int readEqOperator() {
        boolean negated = this.eat("!", false);
        this.forceEat("~", false);
        boolean forall = this.eat("~", false);
        if (negated) {
            forall = !forall;
        }
        return (forall ? 2 : 0) | (negated ? 1 : 0);
    }

    protected Requirement readRequirement() {
        int attrId = this.readAttrId();
        int flags = this.readEqOperator();
        String exp = this.readString();
        String val = exp;
        if (((flags |= this.readFlags()) & 4) > 0) {
            val = "(?iu:" + val + ")";
        }
        if ((flags & 8) > 0) {
            String string = val = val.length() > 0 ? ".*" : ".*" + val + ".*";
        }
        if (attrId > 1 && (val = this.conf.tagset.matchingValues(attrId, val)).length() == 0) {
            this.error("Expression \"" + exp + "\" does not match any values of attribute " + this.conf.tagset.intToAttr(attrId));
        }
        return new Requirement(attrId, val, flags);
    }

    protected TokenRequirement readTokenRequirement() {
        TokenRequirement res = new TokenRequirement(this.conf);
        boolean cont = false;
        while (this.currentCharNotIn(",]")) {
            if (cont) {
                this.forceEat("&&", true);
            }
            res.add(this.readRequirement());
            cont = true;
        }
        return res;
    }

    public int attribute(String s) {
        if (s.equals("type")) {
            return 4;
        }
        if (s.equals("head")) {
            return 3;
        }
        if (s.equals("semh")) {
            return 2;
        }
        if (s.equals("synh")) {
            return 1;
        }
        return -1;
    }

    protected GroupRequirement readGroupRequirement() {
        GroupRequirement res = new GroupRequirement(this.conf);
        boolean cont = false;
        while (this.currentCharNot(']')) {
            if (cont) {
                this.forceEat("&&", true);
            }
            cont = true;
            int lhs = this.attribute(this.readWord("", false));
            if (lhs < 0) {
                this.error("Unknown group attribute");
            }
            this.forceEat("=", false);
            if (lhs == 4) {
                res.setType(this.readString());
                continue;
            }
            this.forceEat("[", true);
            TokenRequirement head = this.readTokenRequirement();
            this.forceEat("]", true);
            res.setHead(lhs, head);
        }
        return res;
    }

    protected EntityRequirement readEntityRequirement() {
        this.eatWhite();
        if (this.eat("ns", true)) {
            return new SpecialRequirement('n', this.conf);
        }
        if (this.eat("sb", true)) {
            return new SpecialRequirement('b', this.conf);
        }
        if (this.eat("se", true)) {
            return new SpecialRequirement('e', this.conf);
        }
        if (this.eat("$", false)) {
            String key = this.readId();
            EntityRequirement res = this.macros.get(key);
            if (res == null) {
                this.error("Undefined macro $" + key);
            }
            return res;
        }
        if (this.eat("(", true)) {
            AltRequirement res = this.readAltRequirement();
            this.forceEat(")", true);
            return res;
        }
        this.forceEat("[", true);
        EntityRequirement res = this.preview("head=") || this.preview("semh=") || this.preview("synh=") || this.preview("type=") ? this.readGroupRequirement() : this.readTokenRequirement();
        this.forceEat("]", true);
        return res;
    }

    protected char readQuantifier() {
        if (this.eat("?", true)) {
            return '?';
        }
        if (this.eat("*", true)) {
            return '*';
        }
        if (this.eat("+", true)) {
            return '+';
        }
        return ' ';
    }

    protected SequenceRequirement readSequenceRequirement() {
        SequenceRequirement res = new SequenceRequirement(this.conf);
        while (this.currentCharNotIn("|);")) {
            EntityRequirement e = this.readEntityRequirement();
            e.setQuantifier(this.readQuantifier());
            res.add(e);
        }
        return res;
    }

    protected AltRequirement readAltRequirement() {
        AltRequirement res = new AltRequirement(this.conf);
        res.add(this.readSequenceRequirement());
        while (this.currentCharNotIn(");")) {
            this.forceEat("|", true);
            res.add(this.readSequenceRequirement());
        }
        return res;
    }

    protected String[] readMatchPattern(String part, boolean required) {
        if (this.eat(part, true)) {
            String[] res = this.readSequenceRequirement().toRegexpArray();
            this.forceEat(";", true);
            return res;
        }
        if (!required) {
            return new String[0];
        }
        this.error(String.valueOf(part) + " expected");
        return null;
    }

    public boolean readMacroDef() {
        if (!this.eat("Define", true)) {
            return false;
        }
        String key = this.readId();
        this.forceEat("=", true);
        this.macros.put(key, this.readAltRequirement());
        this.forceEat(";", true);
        return true;
    }
}

