/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.rules.GazetteerEntry;
import ipipan.spejd.rules.Match;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.TimeWatch;
import ipipan.spejd.util.Util;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeMap;

public class Gazetteer
implements Match {
    TreeMap<String, GazetteerEntry> gaz;
    ArrayList<GazetteerEntry> entryList;
    int order;
    int type;
    Entity[] chunk;
    int pos;
    int gtime;
    TimeWatch timer;
    Config conf;

    public Gazetteer(int order, int type, Config conf) {
        this.conf = conf;
        this.order = order;
        this.type = type;
        this.gaz = new TreeMap();
        this.entryList = new ArrayList();
        this.timer = new TimeWatch();
        this.gtime = 0;
    }

    public void addEntry(GazetteerEntry entry) {
        this.entryList.add(entry);
        Util u = new Util(this.conf);
        String[] keys = entry.fromFile ? u.file(entry.key) : entry.key.split("\\|");
        int i = 0;
        while (i < keys.length) {
            this.gaz.put(keys[i], entry);
            ++i;
        }
    }

    public String concatAttr(int id, Entity[] s, int start, int length, boolean countNospace) {
        StringBuilder res = new StringBuilder();
        boolean nospace = true;
        int len = 0;
        int i = start;
        while (i < s.length) {
            if (s[i].type == 'n') {
                nospace = true;
                if (countNospace) {
                    ++len;
                }
            } else {
                if (!nospace) {
                    res.append(' ');
                }
                res.append(s[i].getAttr(id));
                nospace = false;
                if (++len >= length) break;
            }
            ++i;
        }
        return res.toString();
    }

    public boolean apply(Entity[] chunk) {
        boolean modified = false;
        this.timer.getInterval();
        this.chunk = chunk;
        this.pos = 0;
        while (this.pos <= chunk.length - this.order) {
            String key = this.concatAttr(this.type, chunk, this.pos, this.order, true);
            GazetteerEntry r = this.gaz.get(key);
            if (r != null) {
                System.out.println(key);
                modified |= r.applyActions(this);
            }
            ++this.pos;
        }
        this.gtime = (int)((long)this.gtime + this.timer.getInterval());
        return modified;
    }

    @Override
    public Entity getSingle(int s) {
        System.out.print(this.chunk[this.pos]);
        System.out.println("[" + s + "]");
        return this.chunk[this.pos + s];
    }

    @Override
    public Entity[] getSpec(int s) {
        Entity[] res = new Entity[]{this.chunk[this.pos + s]};
        return res;
    }

    @Override
    public Entity[] get(int[] s) {
        Entity[] res = new Entity[s.length];
        int i = 0;
        while (i < s.length) {
            res[i] = this.chunk[this.pos + s[i]];
            ++i;
        }
        return res;
    }

    @Override
    public Entity[] getMatch() {
        Entity[] res = new Entity[this.order];
        int i = 0;
        while (i < this.order) {
            res[i] = this.chunk[this.pos + i];
            ++i;
        }
        return res;
    }

    public void log(PrintStream log) {
        log.println("Gazetteer: " + this.order);
        log.println("Entries: " + this.entryList.size() + ", keys: " + this.gaz.size());
        log.println();
        for (GazetteerEntry entry : this.entryList) {
            entry.log(log);
        }
    }

    public void report(PrintStream log) {
        GazetteerEntry[] rules = this.entryList.toArray(new GazetteerEntry[0]);
        int completed = 0;
        int matched = 0;
        long tmatch = 0L;
        long taction = 0L;
        int i = 0;
        while (i < rules.length) {
            rules[i].report(log);
            completed += rules[i].completed;
            matched += rules[i].matched;
            taction += rules[i].taction.get();
            ++i;
        }
        log.print("\"Gazetter " + this.order + "\",");
        log.print(completed);
        log.print(',');
        log.print(matched);
        log.print(',');
        log.print((long)this.gtime - taction);
        log.print(',');
        log.print(taction);
        log.print(',');
        log.println(this.gtime);
        System.out.println("Gazetteer " + this.order + " time: " + this.gtime + " ms");
    }
}

