/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.rules.Gazetteer;
import ipipan.spejd.rules.Rule;
import ipipan.spejd.rules.RuleParser;
import ipipan.spejd.rules.Sentence;
import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class RuleSet {
    Rule[] rules;
    Gazetteer[] gazetteers;
    Config conf = null;

    public RuleSet(Config conf) {
        this.conf = conf;
        this.loadRules(conf.rulesFile);
        System.out.println("RuleSet(): " + this.rules.length + " rules compiled, see " + conf.logDir + "rules.compiled for details.");
    }

    public void loadRules(String filename) {
        ArrayList<Rule> ruleSet = new ArrayList<Rule>();
        ArrayList<Gazetteer> gazSet = new ArrayList<Gazetteer>();
        try {
            Rule rule;
            Gazetteer gaz;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            RuleParser parser = new RuleParser(in, this.conf);
            PrintStream log = new PrintStream((OutputStream)new FileOutputStream(String.valueOf(this.conf.logDir) + "rules.compiled"), true, "utf-8");
            while (parser.readMacroDef()) {
            }
            while ((gaz = parser.readGazetteer()) != null) {
                gazSet.add(gaz);
                gaz.log(log);
            }
            while ((rule = parser.readRule()) != null) {
                ruleSet.add(rule);
                rule.log(log);
            }
            in.close();
            log.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.gazetteers = gazSet.toArray(new Gazetteer[0]);
        this.rules = ruleSet.toArray(new Rule[0]);
    }

    public void applyTo(Sentence sentence) throws Exception {
        int i = 0;
        while (i < this.gazetteers.length) {
            if (this.gazetteers[i].apply(sentence.toArray())) {
                sentence.update();
            }
            ++i;
        }
        i = 0;
        while (i < this.rules.length) {
            if (this.rules[i].apply(sentence)) {
                sentence.update();
            }
            ++i;
        }
    }

    public void report() {
        int completed = 0;
        int matched = 0;
        long tmatch = 0L;
        long taction = 0L;
        try {
            PrintStream log = new PrintStream((OutputStream)new FileOutputStream(String.valueOf(this.conf.logDir) + "rules.matched.csv"), true, "utf-8");
            log.print("Rule title,Completed,Matched,");
            log.println("Match[ms],Eval[ms],Time[ms]");
            int i = 0;
            while (i < this.gazetteers.length) {
                this.gazetteers[i].report(log);
                ++i;
            }
            i = 0;
            while (i < this.rules.length) {
                this.rules[i].report(log);
                completed += this.rules[i].completed;
                matched += this.rules[i].matched;
                tmatch += this.rules[i].tmatch.get();
                taction += this.rules[i].taction.get();
                ++i;
            }
            log.print("\"ALL\",");
            log.print(completed);
            log.print(',');
            log.print(matched);
            log.print(',');
            log.print(tmatch);
            log.print(',');
            log.print(taction);
            log.print(',');
            log.println(tmatch + taction);
            log.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Found " + matched + " matches, completed " + completed + " rules, see " + this.conf.logDir + "rules.matched.csv for details.");
    }
}

