/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.tagset;

import ipipan.spejd.tagset.Attribute;
import ipipan.spejd.tagset.Dictionary;
import ipipan.spejd.tagset.InterpretationArray;
import ipipan.spejd.tagset.Pos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.TreeMap;

public class Tagset {
    public static final String undefinedValue = "-";
    public static final String orthAttr = "orth";
    public static final String baseAttr = "base";
    public static final String posAttr = "pos";
    public static final String tagDictFile = "tagdict.ini";
    static final String[] noValues = new String[0];
    static final String defaultCfgFile = "sample.cfg";
    private static final int LOAD_IGNORE = 0;
    private static final int LOAD_POS = 1;
    private static final int LOAD_NAMED = 2;
    private static final int LOAD_ATTR = 3;
    TreeMap<String, Attribute> attrByName;
    TreeMap<String, Attribute> attrByValues;
    TreeMap<String, Integer> valOrder;
    ArrayList<Attribute> allAttributes;
    ArrayList<Pos> posList;
    Dictionary tagDict;

    public Tagset(String filename) {
        this.tagDict = this.createDictionary(filename);
        this.posList = new ArrayList();
        this.attrByName = new TreeMap();
        this.attrByValues = new TreeMap();
        this.valOrder = new TreeMap();
        this.allAttributes = new ArrayList();
        this.addAttribute(orthAttr, noValues);
        this.addAttribute(baseAttr, noValues);
        this.addAttribute(posAttr, noValues);
        this.loadCfgFile(filename);
        System.err.println("Tagset(): " + this.posList.size() + " pos loaded.");
    }

    Dictionary createDictionary(String filename) {
        File f = new File(tagDictFile);
        if (!f.exists()) {
            return new Dictionary();
        }
        if (new File(filename).lastModified() > f.lastModified()) {
            return new Dictionary();
        }
        System.out.println("Using previously saved tag cache.");
        return new Dictionary(tagDictFile);
    }

    void addAttribute(String name, String[] values) {
        Attribute attr = this.attrByName.get(name);
        if (attr == null) {
            attr = new Attribute(this.allAttributes.size(), name, values);
            this.allAttributes.add(attr);
            this.attrByName.put(name, attr);
        } else {
            attr.values = values;
        }
        int i = 0;
        while (i < values.length) {
            this.attrByValues.put(values[i], attr);
            this.valOrder.put(values[i], i);
            ++i;
        }
    }

    void loadCfgFile(String filename) {
        ArrayList<String> posNames = new ArrayList<String>();
        int mode = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            String s = in.readLine();
            while (s != null) {
                if (!(s = s.trim()).startsWith("#") && s.length() != 0) {
                    if (s.startsWith("[")) {
                        mode = s.equals("[POS]") ? 1 : (s.equals("[NAMED-ENTITY]") ? 2 : (s.equals("[ATTR]") ? 3 : 0));
                    } else if (mode != 0) {
                        int i = s.indexOf(61);
                        if (i == -1) {
                            System.out.println("Tagset: invalid line, assignment (=) expected.");
                            System.out.println(s);
                            System.exit(0);
                        }
                        String var = s.substring(0, i).trim();
                        String[] vals = (s = s.substring(i + 1).trim()).length() > 0 ? s.split("\\s+") : noValues;
                        switch (mode) {
                            case 1: {
                                this.posList.add(new Pos(var, vals));
                                posNames.add(var);
                                break;
                            }
                            case 3: {
                                this.addAttribute(var, vals);
                            }
                        }
                    }
                }
                s = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addAttribute(posAttr, posNames.toArray(noValues));
    }

    public char intToChar(int i) {
        return (char)(i + 256);
    }

    public char valueToChar(String value) {
        if (value.equals(undefinedValue)) {
            return '0';
        }
        return this.intToChar(this.valOrder.get(value));
    }

    public int attrToInt(String attr) {
        Attribute res = this.attrByName.get(attr);
        if (res == null) {
            return -1;
        }
        return res.id;
    }

    public String intToAttr(int attrId) {
        if (attrId >= this.allAttributes.size()) {
            return null;
        }
        return this.allAttributes.get((int)attrId).name;
    }

    public String charToValue(int attrId, char valueId) {
        return this.allAttributes.get(attrId).getValue(valueId);
    }

    public String matchingValues(int attrId, String regexp) {
        return this.allAttributes.get(attrId).matchingValues(regexp);
    }

    public int nOfAttributes() {
        return this.allAttributes.size();
    }

    public Pos getPosByName(String name) {
        ListIterator<Pos> it = this.posList.listIterator();
        Pos pos = null;
        while (it.hasNext()) {
            pos = (Pos)it.next();
            if (!pos.name.equals(name)) continue;
            return pos;
        }
        System.err.println("Unknown pos: " + name);
        return null;
    }

    InterpretationArray interpretation(String ctag) {
        String[] tag = ctag.length() > 0 ? ctag.split(":") : new String[]{};
        InterpretationArray res = new InterpretationArray(this.allAttributes.size() - 2);
        int i = 0;
        while (i < tag.length) {
            Attribute a;
            if (tag[i].equals("_")) {
                Pos pos = this.getPosByName(tag[0]);
                if (i > pos.attributes.length) {
                    System.err.println("Tag / tagset mismatch: " + ctag);
                    System.exit(0);
                }
                a = this.attrByName.get(pos.attributes[i - 1].name);
                res.addValues(a, String.valueOf(pos.name) + "*");
            } else if (tag[i].endsWith("*")) {
                a = this.attrByName.get(tag[i].substring(0, tag[i].length() - 1));
                res.addValues(a, tag[i]);
            } else if (tag[i].indexOf(46) > -1) {
                a = this.attrByValues.get(tag[i].split("\\.")[0]);
                res.addValues(a, tag[i]);
            } else {
                a = this.attrByValues.get(tag[i]);
                if (a == null) {
                    System.err.println("Undefined tag part [" + tag[i] + "] in [" + ctag + "].");
                    System.exit(0);
                }
                res.addValue(a, tag[i]);
            }
            ++i;
        }
        return res;
    }

    public String cToFtag(String ctag) {
        String value = this.tagDict.get1(ctag);
        if (value != null) {
            return value;
        }
        value = this.interpretation(ctag).toInterpretation();
        this.tagDict.put(ctag, value);
        return value;
    }

    public String[] cToFtagArray(String ctag) {
        return this.interpretation(ctag).toArray();
    }

    public String fToCtag(String ftag) {
        String value = this.tagDict.get2(ftag);
        if (value != null) {
            return value;
        }
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < ftag.length()) {
            if (ftag.charAt(i) != '0') {
                if (res.length() > 0) {
                    res.append(':');
                }
                res.append(this.charToValue(i + 2, ftag.charAt(i)));
            }
            ++i;
        }
        value = res.toString();
        this.tagDict.put(value, ftag);
        return value;
    }

    public void saveTagDictionary(String logDir) {
        this.tagDict.save(String.valueOf(logDir) + tagDictFile);
    }

    public void printAttributes() {
        int i = 0;
        while (i < this.allAttributes.size()) {
            this.allAttributes.get(i).printValues();
            ++i;
        }
    }
}

