/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.core;

public final class FSAHelpers {
    private static final int[] aflags = new int[]{1, 2, 4, 8, 16, 32};
    private static final String[] sflags = new String[]{"FLEXIBLE", "STOPBIT", "NEXTBIT", "TAILS", "WEIGHTED", "LARGE_DICTIONARIES"};

    private FSAHelpers() {
    }

    public static String flagsToString(int flags) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < aflags.length) {
            if ((flags & aflags[i]) != 0) {
                flags &= ~aflags[i];
                if (res.length() > 0) {
                    res.append(',');
                }
                res.append(sflags[i]);
            }
            ++i;
        }
        if (flags != 0) {
            if (res.length() > 0) {
                res.append(' ');
            }
            res.append("(Some flags were not recognized: " + Integer.toBinaryString(flags) + ")");
        }
        return res.toString();
    }

    public static byte getVersion(int flags) {
        int version = (flags & 1) != 0 ? ((flags & 2) != 0 ? ((flags & 4) != 0 ? ((flags & 8) != 0 ? 7 : ((flags & 0x10) != 0 ? 8 : 5)) : ((flags & 8) != 0 ? 6 : 4)) : ((flags & 4) != 0 ? 2 : 1)) : ((flags & 0x20) != 0 ? -128 : 0);
        return (byte)version;
    }

    public static int getFlags(int version) {
        int flags;
        switch (version) {
            case 0: {
                flags = 0;
                break;
            }
            case -128: {
                flags = 32;
                break;
            }
            case 1: {
                flags = 1;
                break;
            }
            case 2: {
                flags = 5;
                break;
            }
            case 4: {
                flags = 3;
                break;
            }
            case 5: {
                flags = 7;
                break;
            }
            case 6: {
                flags = 11;
                break;
            }
            case 7: {
                flags = 15;
                break;
            }
            default: {
                throw new RuntimeException("Unknown version number. FSA created with unknown options.");
            }
        }
        return flags;
    }

    public static byte[] resizeByteBuffer(byte[] buffer, int newSize) {
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, newBuffer.length));
        return newBuffer;
    }
}

