/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.core;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import morfologik.fsa.core.FSA;
import morfologik.fsa.core.FSAHelpers;

public final class FSAVer5Impl
extends FSA {
    private static final int BITMASK_LASTARC = 2;
    private static final int BITMASK_FINALARC = 1;
    private static final int BITMASK_NEXTBIT = 4;
    protected int arcSize;
    protected static final int gotoOffset = 1;
    protected byte[] arcs;

    @Override
    public int getNumberOfArcs() {
        FSA.Node startNode = this.getStartNode();
        Arc arc = (Arc)startNode.getFirstArc();
        int arcOffset = arc.offset;
        int arcsNumber = 0;
        while (arcOffset < this.arcs.length) {
            ++arcsNumber;
            arcOffset = (this.arcs[arcOffset + 1] & 4) != 0 ? arcOffset + 1 + 1 : arcOffset + 1 + this.gotoLength;
        }
        return arcsNumber;
    }

    @Override
    public int getNumberOfNodes() {
        int offset = 1;
        int nodes = 0;
        while (offset < this.arcs.length) {
            if ((this.arcs[offset] & 2) != 0) {
                ++nodes;
            }
            offset += this.arcSize;
        }
        return nodes;
    }

    public FSAVer5Impl(InputStream fsaStream, String dictionaryEncoding) throws IOException {
        super(fsaStream, dictionaryEncoding);
    }

    @Override
    public FSA.Node getStartNode() {
        return new Node(this.arcSize).getFirstArc().getDestinationNode();
    }

    @Override
    protected void readHeader(DataInput in, long fileSize) throws IOException {
        super.readHeader(in, fileSize);
        if (this.version != 5) {
            throw new IOException("Cannot read FSA in version " + this.version + " (built with flags: " + FSAHelpers.flagsToString(FSAHelpers.getFlags(this.version)) + ")." + " Class " + this.getClass().getName() + " supports version " + 5 + " only (" + FSAHelpers.flagsToString(FSAHelpers.getFlags(5)) + ").");
        }
        this.gotoLength = (byte)(this.gotoLength & 0xF);
        this.arcSize = this.gotoLength + 1;
        int numberOfArcs = (int)fileSize - 8;
        this.arcs = new byte[numberOfArcs];
        in.readFully(this.arcs);
    }

    protected final int gotoFieldToOffset(int start, int n) {
        int r = 0;
        int i = n - 1;
        while (i >= 0) {
            r <<= 8;
            r |= this.arcs[start + i] & 0xFF;
            --i;
        }
        return r;
    }

    private final class Arc
    implements FSA.Arc {
        private final int offset;

        public Arc(int offset) {
            this.offset = offset;
        }

        @Override
        public FSA.Node getDestinationNode() {
            int nodeOffset = this.getDestinationNodeOffset();
            if (nodeOffset == 0) {
                throw new RuntimeException("This is a terminal arc [" + this.offset + "]");
            }
            return new Node(nodeOffset);
        }

        @Override
        public byte getLabel() {
            return FSAVer5Impl.this.arcs[this.offset];
        }

        @Override
        public boolean isLast() {
            return (FSAVer5Impl.this.arcs[this.offset + 1] & 2) != 0;
        }

        @Override
        public boolean isFinal() {
            return (FSAVer5Impl.this.arcs[this.offset + 1] & 1) != 0;
        }

        @Override
        public boolean isTerminal() {
            return this.getDestinationNodeOffset() == 0;
        }

        private int getDestinationNodeOffset() {
            if ((FSAVer5Impl.this.arcs[this.offset + 1] & 4) != 0) {
                return this.offset + 1 + 1;
            }
            return FSAVer5Impl.this.gotoFieldToOffset(this.offset + 1, FSAVer5Impl.this.gotoLength) >>> 3;
        }
    }

    private final class Node
    implements FSA.Node {
        private final int offset;

        public Node(int offset) {
            this.offset = offset;
        }

        @Override
        public FSA.Arc getFirstArc() {
            return new Arc(this.offset);
        }

        @Override
        public FSA.Arc getNextArc(FSA.Arc arc) {
            Arc myArc = (Arc)arc;
            if (myArc.isLast()) {
                return null;
            }
            return new Arc(myArc.offset + FSAVer5Impl.this.arcSize);
        }

        @Override
        public final FSA.Arc getArcLabelledWith(byte label) {
            FSA.Arc arc = this.getFirstArc();
            while (arc != null) {
                if (arc.getLabel() == label) {
                    return arc;
                }
                arc = this.getNextArc(arc);
            }
            return null;
        }
    }
}

