/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.dictionary;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class DictionaryFeatures {
    public static final String ATTR_NAME_SEPARATOR = "fsa.dict.separator";
    public static final String ATTR_NAME_ENCODING = "fsa.dict.encoding";
    public static final String ATTR_NAME_USES_PREFIXES = "fsa.dict.uses-prefixes";
    public static final String ATTR_NAME_USES_INFIXES = "fsa.dict.uses-infixes";
    public final byte separator;
    public final String encoding;
    public final boolean usesPrefixes;
    public final boolean usesInfixes;

    public DictionaryFeatures(char separator, String encoding, boolean usesPrefixes, boolean usesInfixes) {
        this.encoding = encoding;
        this.usesPrefixes = usesPrefixes;
        this.usesInfixes = usesInfixes;
        try {
            byte[] separatorBytes = new String(new char[]{separator}).getBytes(encoding);
            if (separatorBytes.length != 1) {
                throw new RuntimeException("Separator character: " + separator + " must be a single byte after transformation with encoding " + encoding);
            }
            this.separator = separatorBytes[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not supported on this VM: " + encoding);
        }
    }

    static DictionaryFeatures fromMap(Properties properties) throws IOException {
        String separator = properties.getProperty(ATTR_NAME_SEPARATOR);
        if (separator == null || separator.length() != 1) {
            throw new IOException("Attribute fsa.dict.separator must be a single character.");
        }
        String encoding = properties.getProperty(ATTR_NAME_ENCODING);
        if (encoding == null || encoding.length() == 0) {
            throw new IOException("Attribute fsa.dict.encoding must be present and non-empty.");
        }
        boolean usesPrefixes = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_PREFIXES, "false"));
        boolean usesInfixes = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_INFIXES, "false"));
        return new DictionaryFeatures(separator.charAt(0), encoding, usesPrefixes, usesInfixes);
    }
}

