/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemmers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import morfologik.fsa.dictionary.Dictionary;
import morfologik.fsa.dictionary.DictionaryStemmer;
import morfologik.stemmers.IStemmer;
import morfologik.util.ResourceUtils;

public class Lametyzator
implements IStemmer {
    public static final String PROPERTY_NAME_LAMETYZATOR_DICTIONARY = "lametyzator.dictionary";
    private static final String DEFAULT_DICTIONARY_PATH = "/res/polish.dict";
    private final DictionaryStemmer fsaStemmer;

    public Lametyzator() throws IOException {
        String dictionaryResource = System.getProperty(PROPERTY_NAME_LAMETYZATOR_DICTIONARY);
        String fsa = dictionaryResource != null && !"".equals(dictionaryResource) ? dictionaryResource : DEFAULT_DICTIONARY_PATH;
        String features = Dictionary.getExpectedFeaturesName(fsa);
        this.fsaStemmer = new DictionaryStemmer(Dictionary.read(ResourceUtils.openInputStream(fsa), ResourceUtils.openInputStream(features)));
    }

    public Lametyzator(Dictionary dictionary) throws UnsupportedEncodingException {
        this.fsaStemmer = new DictionaryStemmer(dictionary);
    }

    @Override
    public final String[] stem(String word) {
        return this.fsaStemmer.stem(word);
    }

    @Override
    public final String[] stemAndForm(String word) {
        return this.fsaStemmer.stemAndForm(word);
    }
}

