/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemmers;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import morfologik.stemmers.IStemmer;
import morfologik.util.ResourceUtils;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Trie;
import org.getopt.stempel.Stemmer;

public final class Stempel
implements IStemmer {
    public static final String PROPERTY_NAME_STEMPEL_TABLE = "stempel.dictionary";
    private final Stemmer stempel;

    public Stempel() throws IOException {
        String stempelTable = System.getProperty(PROPERTY_NAME_STEMPEL_TABLE);
        if (stempelTable != null && !"".equals(stempelTable)) {
            InputStream is = ResourceUtils.openInputStream(stempelTable);
            Trie trie = Stempel.loadTrie(is);
            this.stempel = new Stemmer(trie);
        } else {
            this.stempel = new Stemmer();
        }
    }

    private static Trie loadTrie(InputStream tableData) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(tableData));
        String method = in.readUTF().toUpperCase();
        Object stemmer = method.indexOf(77) < 0 ? new Trie((DataInput)in) : new MultiTrie2((DataInput)in);
        in.close();
        return stemmer;
    }

    @Override
    public String[] stem(String word) {
        String stem = this.stempel.stem(word, false);
        if (stem != null) {
            return new String[]{stem};
        }
        return null;
    }

    @Override
    public String[] stemAndForm(String word) {
        String stem = this.stempel.stem(word, false);
        if (stem != null) {
            String[] stringArray = new String[2];
            stringArray[0] = stem;
            return stringArray;
        }
        return null;
    }
}

