/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import morfologik.fsa.core.FSA;
import morfologik.fsa.core.FSAHelpers;
import morfologik.fsa.dictionary.Dictionary;
import morfologik.tools.BaseCommandLineTool;
import morfologik.tools.CommandLineOptions;
import morfologik.util.FileUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public final class FSADumpTool
extends BaseCommandLineTool {
    private static final int MAX_BUFFER_SIZE = 5000;
    private static final int BUFFER_INCREMENT = 1000;
    private PrintStream writer;
    private String encoding;
    private static byte[] word = new byte[1000];

    @Override
    protected void go(CommandLine line) throws Exception {
        File dictionaryFile = (File)line.getOptionObject(CommandLineOptions.fsaDictionaryFileOption.getOpt());
        FileUtils.assertExists(dictionaryFile, true, false);
        boolean useAPI = line.hasOption(CommandLineOptions.useApiOption.getOpt());
        this.dump(dictionaryFile, useAPI);
    }

    /*
     * Unable to fully structure code
     */
    private void dump(File dictionaryFile, boolean useAPI) throws UnsupportedEncodingException, IOException {
        block8: {
            block7: {
                start = System.currentTimeMillis();
                if (!dictionaryFile.canRead()) {
                    this.writer.println("Dictionary file does not exist: " + dictionaryFile.getAbsolutePath());
                    return;
                }
                this.writer = System.out;
                if (FSADumpTool.hasFeatures(dictionaryFile)) {
                    dictionary = Dictionary.read(dictionaryFile);
                    fsa = dictionary.fsa;
                    this.encoding = dictionary.features.encoding;
                    if (!Charset.isSupported(this.encoding)) {
                        this.writer.println("Dictionary's charset is not supported on this JVM: " + this.encoding);
                        return;
                    }
                } else {
                    this.encoding = null;
                    dictionary = null;
                    fsa = FSA.getInstance(dictionaryFile, "iso-8859-1");
                    this.writer.println("Warning: FSA automaton without metadata file. Raw bytes emitted.");
                }
                this.writer.println("FSA properties");
                this.writer.println("--------------------");
                this.writer.println("FSA file version    : " + fsa.getVersion());
                this.writer.println("Compiled with flags : " + FSAHelpers.flagsToString(fsa.getFlags()));
                this.writer.println("Number of arcs      : " + fsa.getNumberOfArcs());
                this.writer.println("Number of nodes     : " + fsa.getNumberOfNodes());
                this.writer.println("Annotation separator: " + fsa.getAnnotationSeparator());
                this.writer.println("Filler character    : " + fsa.getFillerCharacter());
                this.writer.println("");
                if (dictionary != null) {
                    decoder = Charset.forName(this.encoding).newDecoder();
                    decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    decoder.onMalformedInput(CodingErrorAction.REPORT);
                    this.writer.println("Dictionary metadata");
                    this.writer.println("--------------------");
                    this.writer.println("Encoding            : " + dictionary.features.encoding);
                    this.writer.println("Separator           : " + decoder.decode(ByteBuffer.wrap(new byte[]{dictionary.features.separator})));
                    this.writer.println("Uses prefixes       : " + dictionary.features.usesPrefixes);
                    this.writer.println("Uses infixes        : " + dictionary.features.usesInfixes);
                    this.writer.println("");
                }
                this.writer.println("FSA data");
                this.writer.println("--------------------");
                if (!useAPI) break block7;
                i = fsa.getTraversalHelper().getAllSubsequences(fsa.getStartNode());
                if (this.encoding == null) ** GOTO lbl53
                while (i.hasNext()) {
                    sequence = (byte[])i.next();
                    this.writer.println(new String(sequence, this.encoding));
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    sequence = (byte[])i.next();
                    this.writer.write(sequence);
                    this.writer.println();
lbl53:
                    // 2 sources

                    ** while (i.hasNext())
                }
lbl54:
                // 1 sources

                break block8;
            }
            this.dumpNode(fsa.getStartNode(), 0);
        }
        this.writer.println("--------------------");
        millis = System.currentTimeMillis() - start;
        this.writer.println(MessageFormat.format("Dictionary dumped in {0,number,#.###} seconds.", new Object[]{new Double((double)millis / 1000.0)}));
    }

    private void dumpNode(FSA.Node node, int depth) throws UnsupportedEncodingException {
        FSA.Arc arc = node.getFirstArc();
        do {
            if (depth >= word.length) {
                if (word.length + 1000 > 5000) {
                    throw new RuntimeException("Error: Buffer limit of 5000 bytes exceeded. A loop in the automaton maybe?");
                }
                word = FSAHelpers.resizeByteBuffer(word, word.length + 1000);
                FSADumpTool.word[depth] = arc.getLabel();
            }
            FSADumpTool.word[depth] = arc.getLabel();
            if (arc.isFinal()) {
                if (this.encoding != null) {
                    this.writer.println(new String(word, 0, depth + 1, this.encoding));
                } else {
                    this.writer.write(word, 0, depth + 1);
                    this.writer.println();
                }
            }
            if (arc.isTerminal()) continue;
            this.dumpNode(arc.getDestinationNode(), depth + 1);
        } while ((arc = node.getNextArc(arc)) != null);
    }

    private static boolean hasFeatures(File fsaFile) {
        File featuresFile = new File(fsaFile.getParent(), Dictionary.getExpectedFeaturesName(fsaFile.getName()));
        return featuresFile.canRead();
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(CommandLineOptions.fsaDictionaryFileOption);
        options.addOption(CommandLineOptions.useApiOption);
    }

    public static void main(String[] args) throws Exception {
        FSADumpTool fsaDump = new FSADumpTool();
        fsaDump.go(args);
    }
}

