/*
 * Decompiled with CFR 0.152.
 */
package com.dawidweiss.ipipan.corpus;

import com.dawidweiss.ipipan.corpus.TagParserException;
import java.util.HashMap;
import java.util.Iterator;

public class Tag {
    public String partOfSpeech;
    private long tagCode;
    public String number;
    public String _case;
    public String gender;
    public String person;
    public String degree;
    public String aspect;
    public String negation;
    public String accommodability;
    public String accentability;
    public String postPrepositionality;
    public String agglutination;
    public String vocalicity;
    private static final boolean EMIT_UNDERSCORE = false;
    public static final long NOUN = 1L;
    public static final long NOUN_SUBST = 17L;
    public static final long NOUN_DEPR = 33L;
    public static final long ADJ = 2L;
    public static final long ADJ_ = 18L;
    public static final long ADJ_A = 34L;
    public static final long ADJ_P = 50L;
    public static final long ADV = 3L;
    public static final long NUM = 4L;
    public static final long PPRON = 5L;
    public static final long PPRON_12 = 21L;
    public static final long PPRON_3 = 37L;
    public static final long PPRON_SIEBIE = 53L;
    public static final long VERB = 6L;
    public static final long VERB_FIN = 22L;
    public static final long VERB_BEDZIE = 38L;
    public static final long VERB_AGLT = 54L;
    public static final long VERB_PRAET = 70L;
    public static final long VERB_IMPT = 86L;
    public static final long VERB_IMPS = 102L;
    public static final long VERB_INF = 118L;
    public static final long VERB_PCON = 134L;
    public static final long VERB_PANT = 150L;
    public static final long VERB_GER = 166L;
    public static final long VERB_PACT = 182L;
    public static final long VERB_PPAS = 198L;
    public static final long WINIEN = 7L;
    public static final long PRED = 8L;
    public static final long PREP = 9L;
    public static final long CONJ = 10L;
    public static final long QUB = 11L;
    public static final long XXS = 12L;
    public static final long XXX = 13L;
    public static final long INTERP = 14L;
    public static final long IGN = 15L;
    public static final long UNKNOWN = 0L;
    public static final long MASK_POS_MAIN = 15L;
    public static final long MASK_POS_SUB = 240L;
    public static final long MASK_POS = 255L;
    public static final long NUMBER_SG = 512L;
    public static final long NUMBER_PL = 1024L;
    public static final long MASK_NUMBER = 1536L;
    public static final long CASE_NOM = 2048L;
    public static final long CASE_GEN = 4096L;
    public static final long CASE_DAT = 8192L;
    public static final long CASE_ACC = 16384L;
    public static final long CASE_INST = 32768L;
    public static final long CASE_LOC = 65536L;
    public static final long CASE_VOC = 131072L;
    public static final long MASK_CASE = 260096L;
    public static final long GENDER_M = 262144L;
    public static final long GENDER_M1 = 786432L;
    public static final long GENDER_M2 = 0x140000L;
    public static final long GENDER_M3 = 0x240000L;
    public static final long GENDER_F = 0x400000L;
    public static final long GENDER_N = 0x800000L;
    public static final long GENDER_N1 = 0x1800000L;
    public static final long GENDER_N2 = 0x2800000L;
    public static final long GENDER_P = 0x4000000L;
    public static final long GENDER_P1 = 0xC000000L;
    public static final long GENDER_P2 = 0x14000000L;
    public static final long GENDER_P3 = 0x24000000L;
    public static final long MASK_GENDER = 1073479680L;
    public static final long PERSON_PRI = 0x40000000L;
    public static final long PERSON_SEC = 0x80000000L;
    public static final long PERSON_TER = 0x100000000L;
    public static final long MASK_PERSON = 0x1C0000000L;
    public static final long DEGREE_POS = 0x200000000L;
    public static final long DEGREE_COMP = 0x400000000L;
    public static final long DEGREE_SUP = 0x800000000L;
    public static final long MASK_DEGREE = 0xE00000000L;
    public static final long ASPECT_PERF = 0x1000000000L;
    public static final long ASPECT_IMPERF = 0x2000000000L;
    public static final long MASK_ASPECT = 0x3000000000L;
    public static final long VOCALITY_WOK = 0x1000000000000L;
    public static final long VOCALITY_NWOK = 0x2000000000000L;
    public static final long AGLUT_AGL = 0x1000000000000L;
    public static final long AGLUT_NAGL = 0x2000000000000L;
    public static final long ACCOM_CONGR = 0x100000000000L;
    public static final long ACCOM_REC = 0x200000000000L;
    public static final long PPRAEP_PRAEP = 0x40000000000L;
    public static final long PPRAEP_NPRAEP = 0x80000000000L;
    public static final long ACC_ACC = 0x10000000000L;
    public static final long ACC_NACC = 0x20000000000L;
    public static final long NEG_AFF = 0x4000000000L;
    public static final long NEG_NEG = 0x8000000000L;
    private static final int EMIT_DEGREE = 1;
    private static final int EMIT_VOCALITY = 2;
    private static final int EMIT_ASPECT = 4;
    private static final int EMIT_CASE = 8;
    private static final int EMIT_NUMBER = 16;
    private static final int EMIT_GENDER = 32;
    private static final int EMIT_NEGATION = 64;
    private static final int EMIT_PERSON = 128;
    private static final int EMIT_POST_PREPOSITIONALITY = 256;
    private static final int EMIT_ACCENTABILITY = 512;
    private static final int EMIT_ACCOMMODABILITY = 1024;
    private static final int EMIT_AGGLUTINATION = 2048;
    private static final HashMap posCodes = new HashMap();
    private static final HashMap ASPECT_VALUES;
    private static final String[] ASPECT_VALUES_ORDER;
    private static final HashMap DEGREE_VALUES;
    private static final String[] DEGREE_VALUES_ORDER;
    private static final HashMap VOCALITY_VALUES;
    private static final String[] VOCALITY_VALUES_ORDER;
    private static final HashMap CASE_VALUES;
    private static final String[] CASE_VALUES_ORDER;
    private static final HashMap NUMBER_VALUES;
    private static final String[] NUMBER_VALUES_ORDER;
    private static final HashMap GENDER_VALUES;
    private static final String[] GENDER_VALUES_ORDER;
    private static final String[] GENDER_VALUES_ORDER_IPI_WSTEPNY;
    private static final HashMap NEGATION_VALUES;
    private static final String[] NEGATION_VALUES_ORDER;
    private static final HashMap PERSON_VALUES;
    private static final String[] PERSON_VALUES_ORDER;
    private static final HashMap ACCENTABILITY_VALUES;
    private static final String[] ACCENTABILITY_VALUES_ORDER;
    private static final HashMap POST_PREPOSITIONALITY_VALUES;
    private static final String[] POST_PREPOSITIONALITY_VALUES_ORDER;
    private static final HashMap ACCOMMODABILITY_VALUES;
    private static final String[] ACCOMMODABILITY_VALUES_ORDER;
    private static final HashMap AGGLUTINATION_VALUES;
    private static final String[] AGGLUTINATION_VALUES_ORDER;

    private Tag(String tagCode) {
        this.parse(tagCode);
    }

    private void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new RuntimeException(message);
        }
    }

    private long assertValidReturnCode(HashMap allowed, String values) {
        long code = 0L;
        if (values.equals("_")) {
            Iterator i = allowed.values().iterator();
            while (i.hasNext()) {
                code |= ((Long)i.next()).longValue();
            }
        } else if (values.indexOf(46) >= 0) {
            String[] v = values.split("\\.");
            for (int i = 0; i < v.length; ++i) {
                Long l = (Long)allowed.get(v[i]);
                if (l == null) {
                    throw new RuntimeException("Illegal attribute value: " + v[i]);
                }
                code |= l.longValue();
            }
        } else {
            Long l = (Long)allowed.get(values);
            if (l == null) {
                throw new RuntimeException("Illegal attribute value: " + values);
            }
            code |= l.longValue();
        }
        return code;
    }

    private long parseAspect(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Aspect not present in tag data.");
        this.aspect = codes[position];
        return this.assertValidReturnCode(ASPECT_VALUES, this.aspect);
    }

    private long parseDegree(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Degree not present in tag data.");
        this.degree = codes[position];
        return this.assertValidReturnCode(DEGREE_VALUES, codes[position]);
    }

    private long parseVocality(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Vocality not present in tag data.");
        this.vocalicity = codes[position];
        return this.assertValidReturnCode(VOCALITY_VALUES, codes[position]);
    }

    private long parseCase(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Case not present in tag data.");
        this._case = codes[position];
        return this.assertValidReturnCode(CASE_VALUES, codes[position]);
    }

    private long parseNumber(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Number not present in tag data.");
        this.number = codes[position];
        return this.assertValidReturnCode(NUMBER_VALUES, codes[position]);
    }

    private long parseGender(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Gender not present in tag data.");
        this.gender = codes[position];
        return this.assertValidReturnCode(GENDER_VALUES, codes[position]);
    }

    private long parseNegation(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Negation not present in tag data.");
        this.negation = codes[position];
        return this.assertValidReturnCode(NEGATION_VALUES, codes[position]);
    }

    private long parsePerson(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Person not present in tag data.");
        this.person = codes[position];
        return this.assertValidReturnCode(PERSON_VALUES, codes[position]);
    }

    private long parseAccentability(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Accentability not present in tag data.");
        this.accentability = codes[position];
        return this.assertValidReturnCode(ACCENTABILITY_VALUES, codes[position]);
    }

    private long parsePostPrepositionality(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Post-prepositionality not present in tag data.");
        this.postPrepositionality = codes[position];
        return this.assertValidReturnCode(POST_PREPOSITIONALITY_VALUES, codes[position]);
    }

    private long parseAccommodability(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Accommodability not present in tag data.");
        this.accommodability = codes[position];
        return this.assertValidReturnCode(ACCOMMODABILITY_VALUES, codes[position]);
    }

    private long parseAgglutination(String[] codes, int position) {
        this.assertTrue(position < codes.length, "Agglutination not present in tag data.");
        this.agglutination = codes[position];
        return this.assertValidReturnCode(AGGLUTINATION_VALUES, codes[position]);
    }

    private void parse(String tagCode) {
        int i;
        String[] codes = tagCode.split(":");
        this.partOfSpeech = codes[0];
        long tagLongCode = 0L;
        if ("adja".equals(this.partOfSpeech) || "adjp".equals(this.partOfSpeech) || "conj".equals(this.partOfSpeech) || "interp".equals(this.partOfSpeech) || "pred".equals(this.partOfSpeech) || "xxx".equals(this.partOfSpeech) || "ign".equals(this.partOfSpeech)) {
            this.assertTrue(codes.length == 1, "Unknown extra data associated with POS tag: " + this.partOfSpeech);
        } else if ("adv".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseDegree(codes, 1);
            this.assertTrue(codes.length == 2, "Incorrect extra tag data: " + tagCode);
        } else if ("imps".equals(this.partOfSpeech) || "inf".equals(this.partOfSpeech) || "pant".equals(this.partOfSpeech) || "pcon".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseAspect(codes, 1);
            this.assertTrue(codes.length == 2, "Incorrect extra tag data: " + tagCode);
        } else if ("qub".equals(this.partOfSpeech)) {
            if (codes.length > 1) {
                tagLongCode |= this.parseVocality(codes, 1);
                this.assertTrue(codes.length == 2, "Incorrect extra tag data: " + tagCode);
            } else {
                this.assertTrue(codes.length == 1, "Incorrect extra tag data: " + tagCode);
            }
        } else if ("prep".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseCase(codes, 1);
            if (codes.length > 2) {
                tagLongCode |= this.parseVocality(codes, 2);
                this.assertTrue(codes.length == 3, "Incorrect extra tag data: " + tagCode);
            } else {
                this.assertTrue(codes.length == 2, "Incorrect extra tag data: " + tagCode);
            }
        } else if ("siebie".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseCase(codes, 1);
        } else if ("subst".equals(this.partOfSpeech) || "depr".equals(this.partOfSpeech) || "xxs".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            this.assertTrue(codes.length == 4, "Incorrect extra tag data: " + tagCode);
        } else if ("ger".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            tagLongCode |= this.parseAspect(codes, 4);
            tagLongCode |= this.parseNegation(codes, 5);
            this.assertTrue(codes.length == 6, "Incorrect extra tag data: " + tagCode);
        } else if ("ppron12".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            tagLongCode |= this.parsePerson(codes, 4);
            if (codes.length > 5) {
                tagLongCode |= this.parseAccentability(codes, 5);
                this.assertTrue(codes.length == 6, "Incorrect extra tag data: " + tagCode);
            } else {
                this.assertTrue(codes.length == 5, "Incorrect extra tag data: " + tagCode);
            }
        } else if ("ppron3".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            tagLongCode |= this.parsePerson(codes, 4);
            i = 5;
            if (codes.length > 5) {
                if (!codes[i].endsWith("p")) {
                    tagLongCode |= this.parseAccentability(codes, i);
                    ++i;
                }
                if (i < codes.length) {
                    tagLongCode |= this.parsePostPrepositionality(codes, i);
                    ++i;
                }
            }
            this.assertTrue(codes.length == i, "Incorrect extra tag data: " + tagCode);
        } else if ("num".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            if (codes.length > 4) {
                tagLongCode |= this.parseAccommodability(codes, 4);
            }
        } else if ("adj".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            tagLongCode |= this.parseDegree(codes, 4);
            this.assertTrue(codes.length == 5, "Incorrect extra tag data: " + tagCode);
        } else if ("pact".equals(this.partOfSpeech) || "ppas".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseCase(codes, 2);
            tagLongCode |= this.parseGender(codes, 3);
            tagLongCode |= this.parseAspect(codes, 4);
            tagLongCode |= this.parseNegation(codes, 5);
            this.assertTrue(codes.length == 6, "Incorrect extra tag data: " + tagCode);
        } else if ("bedzie".equals(this.partOfSpeech) || "fin".equals(this.partOfSpeech) || "impt".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parsePerson(codes, 2);
            tagLongCode |= this.parseAspect(codes, 3);
            this.assertTrue(codes.length == 4, "Incorrect extra tag data: " + tagCode);
        } else if ("winien".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseGender(codes, 2);
            tagLongCode |= this.parseAspect(codes, 3);
            this.assertTrue(codes.length == 4, "Incorrect extra tag data: " + tagCode);
        } else if ("praet".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parseGender(codes, 2);
            tagLongCode |= this.parseAspect(codes, 3);
            i = 4;
            if (codes.length > 4) {
                tagLongCode |= this.parseAgglutination(codes, i);
                ++i;
            }
            this.assertTrue(codes.length == i, "Incorrect extra tag data: " + tagCode);
        } else if ("aglt".equals(this.partOfSpeech)) {
            tagLongCode |= this.parseNumber(codes, 1);
            tagLongCode |= this.parsePerson(codes, 2);
            tagLongCode |= this.parseAspect(codes, 3);
            tagLongCode |= this.parseVocality(codes, 4);
            this.assertTrue(codes.length == 5, "Incorrect extra tag data: " + tagCode);
        } else {
            throw new TagParserException("Unknown POS tag: '" + tagCode + "'");
        }
        Long posCode = (Long)posCodes.get(this.partOfSpeech);
        this.tagCode = tagLongCode |= posCode.longValue();
    }

    public long getCode() {
        return this.tagCode;
    }

    public static String toString(long code) {
        StringBuffer buf = new StringBuffer();
        switch ((int)(code & 0xFFL)) {
            case 17: {
                buf.append("subst");
                break;
            }
            case 33: {
                buf.append("depr");
                break;
            }
            case 1: {
                buf.append("NOUN");
                break;
            }
            case 2: {
                buf.append("ADJ");
                break;
            }
            case 18: {
                buf.append("adj");
                break;
            }
            case 34: {
                buf.append("adja");
                break;
            }
            case 50: {
                buf.append("adjp");
                break;
            }
            case 3: {
                buf.append("adv");
                break;
            }
            case 4: {
                buf.append("num");
                break;
            }
            case 5: {
                buf.append("ppron");
                break;
            }
            case 21: {
                buf.append("ppron12");
                break;
            }
            case 37: {
                buf.append("ppron3");
                break;
            }
            case 53: {
                buf.append("siebie");
                break;
            }
            case 6: {
                buf.append("VERB");
                break;
            }
            case 22: {
                buf.append("fin");
                break;
            }
            case 38: {
                buf.append("bedzie");
                break;
            }
            case 54: {
                buf.append("aglt");
                break;
            }
            case 70: {
                buf.append("praet");
                break;
            }
            case 86: {
                buf.append("impt");
                break;
            }
            case 102: {
                buf.append("imps");
                break;
            }
            case 118: {
                buf.append("inf");
                break;
            }
            case 134: {
                buf.append("pcon");
                break;
            }
            case 150: {
                buf.append("pant");
                break;
            }
            case 166: {
                buf.append("ger");
                break;
            }
            case 182: {
                buf.append("pact");
                break;
            }
            case 198: {
                buf.append("ppas");
                break;
            }
            case 7: {
                buf.append("winien");
                break;
            }
            case 8: {
                buf.append("pred");
                break;
            }
            case 9: {
                buf.append("prep");
                break;
            }
            case 10: {
                buf.append("conj");
                break;
            }
            case 11: {
                buf.append("qub");
                break;
            }
            case 12: {
                buf.append("xxs");
                break;
            }
            case 13: {
                buf.append("xxx");
                break;
            }
            case 14: {
                buf.append("interp");
                break;
            }
            case 15: {
                buf.append("ign");
                break;
            }
            case 0: {
                buf.append("?");
                break;
            }
            default: {
                throw new RuntimeException("Unreachable state.");
            }
        }
        int emitChunks = 0;
        switch ((int)(code & 0xFFL)) {
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 34: 
            case 50: {
                break;
            }
            case 3: {
                emitChunks |= 1;
                break;
            }
            case 102: 
            case 118: 
            case 134: 
            case 150: {
                emitChunks |= 4;
                break;
            }
            case 11: {
                emitChunks |= 2;
                break;
            }
            case 9: {
                emitChunks |= 0xA;
                break;
            }
            case 5: {
                emitChunks |= 0x3B8;
                break;
            }
            case 53: {
                emitChunks |= 8;
                break;
            }
            case 1: 
            case 12: 
            case 17: 
            case 33: {
                emitChunks |= 0x38;
                break;
            }
            case 166: {
                emitChunks |= 0x7C;
                break;
            }
            case 21: {
                emitChunks |= 0x2B8;
                break;
            }
            case 37: {
                emitChunks |= 0x3B8;
                break;
            }
            case 4: {
                emitChunks |= 0x438;
                break;
            }
            case 2: 
            case 18: {
                emitChunks |= 0x39;
                break;
            }
            case 6: 
            case 182: 
            case 198: {
                emitChunks |= 0x7C;
                break;
            }
            case 22: 
            case 38: 
            case 86: {
                emitChunks |= 0x94;
                break;
            }
            case 7: {
                emitChunks |= 0x34;
                break;
            }
            case 70: {
                emitChunks |= 0x834;
                break;
            }
            case 54: {
                emitChunks |= 0x96;
                break;
            }
            default: {
                throw new RuntimeException("Unreachable state.");
            }
        }
        if ((emitChunks & 0x10) != 0 && (code & 0x600L) != 0L) {
            Tag.emit(buf, NUMBER_VALUES_ORDER, NUMBER_VALUES, code);
        }
        if ((emitChunks & 8) != 0) {
            Tag.emit(buf, CASE_VALUES_ORDER, CASE_VALUES, code);
        }
        if ((emitChunks & 0x20) != 0 && (code & 0x3FFC0000L) != 0L) {
            String[] codesOrder = (code & 0x3800000L) == 0x800000L ? GENDER_VALUES_ORDER_IPI_WSTEPNY : GENDER_VALUES_ORDER;
            Tag.emit(buf, codesOrder, GENDER_VALUES, code & 0x3FFC0000L);
        }
        if ((emitChunks & 0x80) != 0) {
            Tag.emit(buf, PERSON_VALUES_ORDER, PERSON_VALUES, code);
        }
        if ((emitChunks & 1) != 0) {
            Tag.emit(buf, DEGREE_VALUES_ORDER, DEGREE_VALUES, code);
        }
        if ((emitChunks & 4) != 0) {
            Tag.emit(buf, ASPECT_VALUES_ORDER, ASPECT_VALUES, code);
        }
        if ((emitChunks & 0x40) != 0) {
            Tag.emit(buf, NEGATION_VALUES_ORDER, NEGATION_VALUES, code);
        }
        if ((emitChunks & 0x200) != 0) {
            Tag.emit(buf, ACCENTABILITY_VALUES_ORDER, ACCENTABILITY_VALUES, code);
        }
        if ((emitChunks & 0x100) != 0) {
            Tag.emit(buf, POST_PREPOSITIONALITY_VALUES_ORDER, POST_PREPOSITIONALITY_VALUES, code);
        }
        if ((emitChunks & 0x400) != 0) {
            Tag.emit(buf, ACCOMMODABILITY_VALUES_ORDER, ACCOMMODABILITY_VALUES, code);
        }
        if ((emitChunks & 0x800) != 0) {
            Tag.emit(buf, AGGLUTINATION_VALUES_ORDER, AGGLUTINATION_VALUES, code);
        }
        if ((emitChunks & 2) != 0) {
            Tag.emit(buf, VOCALITY_VALUES_ORDER, VOCALITY_VALUES, code);
        }
        return buf.toString();
    }

    public String toString() {
        return Tag.toString(this.tagCode);
    }

    private static void emit(StringBuffer buf, String[] keys, HashMap values, long code) {
        buf.append(':');
        boolean emitted = false;
        long allValues = 0L;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            long bitmask = (Long)values.get(key);
            allValues |= bitmask;
            if ((code & bitmask) != bitmask) continue;
            if (emitted) {
                buf.append('.');
            } else {
                emitted = true;
            }
            buf.append(key);
        }
        if (!emitted) {
            buf.deleteCharAt(buf.length() - 1);
        }
    }

    public static Tag[] create(String tagAlternatives) {
        if (tagAlternatives.length() == 0) {
            return new Tag[0];
        }
        String[] codes = tagAlternatives.split("\\|");
        Tag[] tagList = new Tag[codes.length];
        for (int i = 0; i < tagList.length; ++i) {
            tagList[i] = new Tag(codes[i]);
        }
        return tagList;
    }

    public static boolean contained(long widerTag, long narrowTag) {
        if ((widerTag & 0xFFL) == (narrowTag & 0xFFL)) {
            long masked = narrowTag & widerTag;
            if ((widerTag & 0x3000000000L) != 0L && (masked & 0x3000000000L) == 0L) {
                return false;
            }
            if ((widerTag & 0x3F800L) != 0L && (masked & 0x3F800L) == 0L) {
                return false;
            }
            if ((widerTag & 0xE00000000L) != 0L && (masked & 0xE00000000L) == 0L) {
                return false;
            }
            if ((widerTag & 0x3FFC0000L) != 0L && (masked & 0x3FFC0000L) == 0L) {
                return false;
            }
            if ((widerTag & 0x600L) != 0L && (masked & 0x600L) == 0L) {
                return false;
            }
            return (widerTag & 0x1C0000000L) == 0L || (masked & 0x1C0000000L) != 0L;
        }
        return false;
    }

    static {
        posCodes.put("subst", new Long(17L));
        posCodes.put("depr", new Long(33L));
        posCodes.put("adj", new Long(18L));
        posCodes.put("adja", new Long(34L));
        posCodes.put("adjp", new Long(50L));
        posCodes.put("adv", new Long(3L));
        posCodes.put("num", new Long(4L));
        posCodes.put("ppron12", new Long(21L));
        posCodes.put("ppron3", new Long(37L));
        posCodes.put("siebie", new Long(53L));
        posCodes.put("fin", new Long(22L));
        posCodes.put("bedzie", new Long(38L));
        posCodes.put("aglt", new Long(54L));
        posCodes.put("praet", new Long(70L));
        posCodes.put("impt", new Long(86L));
        posCodes.put("imps", new Long(102L));
        posCodes.put("inf", new Long(118L));
        posCodes.put("pcon", new Long(134L));
        posCodes.put("pant", new Long(150L));
        posCodes.put("ger", new Long(166L));
        posCodes.put("pact", new Long(182L));
        posCodes.put("ppas", new Long(198L));
        posCodes.put("winien", new Long(7L));
        posCodes.put("pred", new Long(8L));
        posCodes.put("prep", new Long(9L));
        posCodes.put("conj", new Long(10L));
        posCodes.put("qub", new Long(11L));
        posCodes.put("xxs", new Long(12L));
        posCodes.put("xxx", new Long(13L));
        posCodes.put("interp", new Long(14L));
        posCodes.put("ign", new Long(15L));
        ASPECT_VALUES = new HashMap();
        ASPECT_VALUES_ORDER = new String[]{"imperf", "perf"};
        ASPECT_VALUES.put("imperf", new Long(0x2000000000L));
        ASPECT_VALUES.put("perf", new Long(0x1000000000L));
        DEGREE_VALUES = new HashMap();
        DEGREE_VALUES_ORDER = new String[]{"pos", "comp", "sup"};
        DEGREE_VALUES.put("pos", new Long(0x200000000L));
        DEGREE_VALUES.put("comp", new Long(0x400000000L));
        DEGREE_VALUES.put("sup", new Long(0x800000000L));
        VOCALITY_VALUES = new HashMap();
        VOCALITY_VALUES_ORDER = new String[]{"wok", "nwok"};
        VOCALITY_VALUES.put("nwok", new Long(0x2000000000000L));
        VOCALITY_VALUES.put("wok", new Long(0x1000000000000L));
        CASE_VALUES = new HashMap();
        CASE_VALUES_ORDER = new String[]{"nom", "gen", "dat", "acc", "inst", "loc", "voc"};
        CASE_VALUES.put("nom", new Long(2048L));
        CASE_VALUES.put("gen", new Long(4096L));
        CASE_VALUES.put("dat", new Long(8192L));
        CASE_VALUES.put("acc", new Long(16384L));
        CASE_VALUES.put("inst", new Long(32768L));
        CASE_VALUES.put("loc", new Long(65536L));
        CASE_VALUES.put("voc", new Long(131072L));
        NUMBER_VALUES = new HashMap();
        NUMBER_VALUES_ORDER = new String[]{"sg", "pl"};
        NUMBER_VALUES.put("sg", new Long(512L));
        NUMBER_VALUES.put("pl", new Long(1024L));
        GENDER_VALUES = new HashMap();
        GENDER_VALUES_ORDER = new String[]{"m1", "m2", "m3", "f", "n1", "n2", "p1", "p2", "p3"};
        GENDER_VALUES_ORDER_IPI_WSTEPNY = new String[]{"m1", "m2", "m3", "f", "n", "p1", "p2", "p3"};
        GENDER_VALUES.put("m1", new Long(786432L));
        GENDER_VALUES.put("m2", new Long(0x140000L));
        GENDER_VALUES.put("m3", new Long(0x240000L));
        GENDER_VALUES.put("f", new Long(0x400000L));
        GENDER_VALUES.put("n1", new Long(0x1800000L));
        GENDER_VALUES.put("n2", new Long(0x2800000L));
        GENDER_VALUES.put("n", new Long(0x800000L));
        GENDER_VALUES.put("p1", new Long(0xC000000L));
        GENDER_VALUES.put("p2", new Long(0x14000000L));
        GENDER_VALUES.put("p3", new Long(0x24000000L));
        NEGATION_VALUES = new HashMap();
        NEGATION_VALUES_ORDER = new String[]{"aff", "neg"};
        NEGATION_VALUES.put("aff", new Long(0x4000000000L));
        NEGATION_VALUES.put("neg", new Long(0x8000000000L));
        PERSON_VALUES = new HashMap();
        PERSON_VALUES_ORDER = new String[]{"pri", "sec", "ter"};
        PERSON_VALUES.put("pri", new Long(0x40000000L));
        PERSON_VALUES.put("sec", new Long(0x80000000L));
        PERSON_VALUES.put("ter", new Long(0x100000000L));
        ACCENTABILITY_VALUES = new HashMap();
        ACCENTABILITY_VALUES_ORDER = new String[]{"akc", "nakc"};
        ACCENTABILITY_VALUES.put("akc", new Long(0x10000000000L));
        ACCENTABILITY_VALUES.put("nakc", new Long(0x20000000000L));
        POST_PREPOSITIONALITY_VALUES = new HashMap();
        POST_PREPOSITIONALITY_VALUES_ORDER = new String[]{"praep", "npraep"};
        POST_PREPOSITIONALITY_VALUES.put("npraep", new Long(0x80000000000L));
        POST_PREPOSITIONALITY_VALUES.put("praep", new Long(0x40000000000L));
        ACCOMMODABILITY_VALUES = new HashMap();
        ACCOMMODABILITY_VALUES_ORDER = new String[]{"congr", "rec"};
        ACCOMMODABILITY_VALUES.put("congr", new Long(0x100000000000L));
        ACCOMMODABILITY_VALUES.put("rec", new Long(0x200000000000L));
        AGGLUTINATION_VALUES = new HashMap();
        AGGLUTINATION_VALUES_ORDER = new String[]{"agl", "nagl"};
        AGGLUTINATION_VALUES.put("agl", new Long(0x1000000000000L));
        AGGLUTINATION_VALUES.put("nagl", new Long(0x2000000000000L));
    }
}

