/*
 * Decompiled with CFR 0.152.
 */
package com.dawidweiss.morfeusz;

import com.dawidweiss.morfeusz.Analyzer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class Morfeusz {
    static final String ENCODING_UTF8 = "UTF-8";
    static final String ENCODING_ISO8859_2 = "iso8859-2";
    static final String ENCODING_CP1250 = "Cp1250";
    static final String ENCODING_CP852 = "Cp852";
    public static final int MORFOPT_ENCODING = 1;
    public static final int MORFEUSZ_ISO8859_2 = 88592;
    public static final int MORFEUSZ_CP1250 = 1250;
    public static final int MORFEUSZ_CP852 = 852;
    public static final int MORFEUSZ_UTF8 = 8;
    private static final int MORFEUSZ_DEFAULT_ENCODING = 8;
    private static Morfeusz instance;
    private String aboutInfo;
    private final String encoding;

    private Morfeusz(int morfeuszEncoding) {
        this.encoding = Morfeusz.encodingToCodePage(morfeuszEncoding);
        if (this.morfeusz_set_option(1, morfeuszEncoding) != 1) {
            throw new RuntimeException("Morfeusz option MORFOPT_ENCODING could not be set to the default encoding: " + Morfeusz.instance.encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Morfeusz getInstance() throws UnsupportedEncodingException, SecurityException, UnsatisfiedLinkError {
        Class clazz = Morfeusz.class;
        synchronized (clazz) {
            if (instance != null) {
                return instance;
            }
            Runtime.getRuntime().loadLibrary("morfeusz-java");
            Morfeusz instance = new Morfeusz(8);
            instance.aboutInfo = new String(instance.aboutJniNative(), ENCODING_ISO8859_2) + "\n\n";
            InputStream is = instance.getClass().getResourceAsStream("/res/version.txt");
            if (is == null) {
                instance.aboutInfo = instance.aboutInfo + "Java JNI binding code (c) Dawid Weiss\n(no version info)";
            } else {
                try {
                    Properties p = new Properties();
                    p.load(is);
                    instance.aboutInfo = instance.aboutInfo + p.getProperty("copyclause") + "\n";
                    instance.aboutInfo = instance.aboutInfo + "Version: " + p.getProperty("version") + "\n";
                    instance.aboutInfo = instance.aboutInfo + "SVN-Id: " + p.getProperty("svnid") + "\n";
                }
                catch (IOException e) {
                    instance.aboutInfo = instance.aboutInfo + "Java JNI binding code (c) Dawid Weiss\n(exception reading version info)";
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Morfeusz.instance = instance;
            return instance;
        }
    }

    public String about() {
        return this.aboutInfo;
    }

    public Analyzer getAnalyzer() {
        return new Analyzer(this.encoding);
    }

    private native byte[] aboutJniNative();

    public native int morfeusz_set_option(int var1, int var2);

    private static String encodingToCodePage(int morfeuszEncoding) {
        switch (morfeuszEncoding) {
            case 1250: {
                return ENCODING_CP1250;
            }
            case 88592: {
                return ENCODING_ISO8859_2;
            }
            case 852: {
                return ENCODING_CP852;
            }
            case 8: {
                return ENCODING_UTF8;
            }
        }
        throw new IllegalArgumentException("Unknown encoding: " + morfeuszEncoding);
    }
}

