/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import org.egothor.stemmer.Cell;

public class Row {
    TreeMap cells = new TreeMap();
    int uniformCnt = 0;
    int uniformSkip = 0;

    public Row(DataInput dataInput) throws IOException {
        for (int i = dataInput.readInt(); i > 0; --i) {
            Character c = new Character(dataInput.readChar());
            Cell cell = new Cell();
            cell.cmd = dataInput.readInt();
            cell.cnt = dataInput.readInt();
            cell.ref = dataInput.readInt();
            cell.skip = dataInput.readInt();
            this.cells.put(c, cell);
        }
    }

    public Row() {
    }

    public Row(Row row) {
        this.cells = row.cells;
    }

    public void setCmd(Character c, int n) {
        Cell cell = this.at(c);
        if (cell == null) {
            cell = new Cell();
            cell.cmd = n;
            this.cells.put(c, cell);
        } else {
            cell.cmd = n;
        }
        cell.cnt = n >= 0 ? 1 : 0;
    }

    public void setRef(Character c, int n) {
        Cell cell = this.at(c);
        if (cell == null) {
            cell = new Cell();
            cell.ref = n;
            this.cells.put(c, cell);
        } else {
            cell.ref = n;
        }
    }

    public int getCells() {
        Iterator iterator = this.cells.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            Cell cell = this.at(c);
            if (cell.cmd < 0 && cell.ref < 0) continue;
            ++n;
        }
        return n;
    }

    public int getCellsPnt() {
        Iterator iterator = this.cells.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            Cell cell = this.at(c);
            if (cell.ref < 0) continue;
            ++n;
        }
        return n;
    }

    public int getCellsVal() {
        Iterator iterator = this.cells.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            Cell cell = this.at(c);
            if (cell.cmd < 0) continue;
            ++n;
        }
        return n;
    }

    public int getCmd(Character c) {
        Cell cell = this.at(c);
        return cell == null ? -1 : cell.cmd;
    }

    public int getCnt(Character c) {
        Cell cell = this.at(c);
        return cell == null ? -1 : cell.cnt;
    }

    public int getRef(Character c) {
        Cell cell = this.at(c);
        return cell == null ? -1 : cell.ref;
    }

    public void store(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.cells.size());
        Iterator iterator = this.cells.keySet().iterator();
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            Cell cell = this.at(c);
            if (cell.cmd < 0 && cell.ref < 0) continue;
            dataOutput.writeChar(c.charValue());
            dataOutput.writeInt(cell.cmd);
            dataOutput.writeInt(cell.cnt);
            dataOutput.writeInt(cell.ref);
            dataOutput.writeInt(cell.skip);
        }
    }

    public int uniformCmd(boolean bl) {
        Iterator iterator = this.cells.values().iterator();
        int n = -1;
        this.uniformCnt = 1;
        this.uniformSkip = 0;
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            if (cell.ref >= 0) {
                return -1;
            }
            if (cell.cmd < 0) continue;
            if (n < 0) {
                n = cell.cmd;
                this.uniformSkip = cell.skip;
                continue;
            }
            if (n == cell.cmd) {
                if (bl) {
                    if (this.uniformSkip == cell.skip) {
                        ++this.uniformCnt;
                        continue;
                    }
                    return -1;
                }
                ++this.uniformCnt;
                continue;
            }
            return -1;
        }
        return n;
    }

    public void print() {
        Iterator iterator = this.cells.keySet().iterator();
        while (iterator.hasNext()) {
            Character c = (Character)iterator.next();
            Cell cell = this.at(c);
            System.out.print("[" + c + ":" + cell + "]");
        }
        System.out.println();
    }

    Cell at(Character c) {
        return (Cell)this.cells.get(c);
    }
}

