/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.egothor.stemmer.Diff;
import org.egothor.stemmer.Gener;
import org.egothor.stemmer.Lift;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Optimizer;
import org.egothor.stemmer.Optimizer2;
import org.egothor.stemmer.Reduce;
import org.egothor.stemmer.Trie;

public class TestAll {
    static boolean backward;
    static boolean multi;
    static Trie trie;

    public static void selfTest() {
        int n;
        Trie trie = new Trie(true);
        String[] stringArray = new String[]{"a", "ba", "bb", "c"};
        String[] stringArray2 = new String[]{"1", "2", "2", "4"};
        for (n = 0; n < stringArray.length; ++n) {
            trie.add(stringArray[n], stringArray2[n]);
        }
        System.out.println("Trie root:" + trie.root + " size:" + trie.rows.size() + " keys:" + trie.cmds.size());
        trie = trie.reduce(new Optimizer());
        System.out.println("Trie root:" + trie.root + " size:" + trie.rows.size() + " keys:" + trie.cmds.size());
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n] + " ---> " + trie.getFully(stringArray[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n] + " -l-> " + trie.getLastOnPath(stringArray[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n] + " -l-> " + TestAll.astr(trie.getAll(stringArray[n])));
        }
        System.out.println("ac -l-> " + trie.getLastOnPath("ac"));
        System.out.println("abc -l-> " + trie.getLastOnPath("abc"));
        System.out.println("ac -l-> " + TestAll.astr(trie.getAll("ac")));
        System.out.println("abc -l-> " + TestAll.astr(trie.getAll("abc")));
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            TestAll.selfTest();
            return;
        }
        stringArray[0].toUpperCase();
        backward = stringArray[0].charAt(0) == '-';
        int n2 = backward ? 1 : 0;
        boolean bl = false;
        if (stringArray[0].charAt(n2) == '0') {
            bl = true;
            ++n2;
        }
        boolean bl2 = multi = stringArray[0].charAt(n2) == 'M';
        if (multi) {
            ++n2;
        }
        char[] cArray = new char[stringArray[0].length() - n2];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = stringArray[0].charAt(n2 + n);
        }
        for (n = 1; n < stringArray.length; ++n) {
            Diff diff = new Diff();
            try {
                int n3 = 0;
                int n4 = 0;
                LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[n])));
                Object object = lineNumberReader.readLine();
                while (object != null) {
                    try {
                        object = ((String)object).toLowerCase();
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                        String string = stringTokenizer.nextToken();
                        if (bl) {
                            ++n4;
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            if (string2.equals(string)) continue;
                            ++n4;
                        }
                        ++n3;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    object = lineNumberReader.readLine();
                }
                System.out.println("# words stems");
                System.out.println("H: " + n4 + " " + n3);
                object = new double[]{1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03};
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    int n5 = 0;
                    boolean bl3 = false;
                    int n6 = (int)((double)n4 * object[i]);
                    Random random = new Random();
                    TestAll.allocTrie();
                    lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[n])));
                    String string = lineNumberReader.readLine();
                    while (string != null) {
                        try {
                            string = string.toLowerCase();
                            object4 = new StringTokenizer(string);
                            object3 = ((StringTokenizer)object4).nextToken();
                            if (bl && random.nextInt(n4) < n6) {
                                trie.add((String)object3, "-a");
                                ++n5;
                            }
                            while (((StringTokenizer)object4).hasMoreTokens()) {
                                object2 = ((StringTokenizer)object4).nextToken();
                                if (((String)object2).equals(object3) || random.nextInt(n4) >= n6) continue;
                                trie.add((String)object2, diff.exec((String)object2, (String)object3));
                                ++n5;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        string = lineNumberReader.readLine();
                    }
                    string = Integer.toString(100 * (n4 - n5) / n4);
                    object4 = new Optimizer();
                    object3 = new Optimizer2();
                    object2 = new Lift(true);
                    Lift lift = new Lift(false);
                    Gener gener = new Gener();
                    block21: for (int j = 0; j < cArray.length; ++j) {
                        switch (cArray[j]) {
                            case 'G': {
                                trie = trie.reduce(gener);
                                String string3 = "G: ";
                                continue block21;
                            }
                            case 'L': {
                                trie = trie.reduce((Reduce)object2);
                                String string3 = "L: ";
                                continue block21;
                            }
                            case 'E': {
                                trie = trie.reduce(lift);
                                String string3 = "E: ";
                                continue block21;
                            }
                            case '2': {
                                trie = trie.reduce((Reduce)object3);
                                String string3 = "2: ";
                                continue block21;
                            }
                            case '1': {
                                trie = trie.reduce((Reduce)object4);
                                String string3 = "1: ";
                                continue block21;
                            }
                        }
                    }
                    System.out.print("All: " + (100.0 - object[i] * 100.0) + " ");
                    TestAll.testTrie(trie, stringArray[n], bl);
                }
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static String astr(String[] stringArray) {
        if (stringArray == null) {
            return "<null>";
        }
        String string = "<";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + ";";
        }
        return string + stringArray[stringArray.length - 1] + ">";
    }

    static void allocTrie() {
        trie = multi ? new MultiTrie2(!backward) : new Trie(!backward);
    }

    static void testTrie(Trie trie, String string, boolean bl) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
            int n = 0;
            int n2 = 0;
            Diff diff = new Diff();
            int n3 = 0;
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                try {
                    Object object;
                    string2 = string2.toLowerCase();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    String string3 = stringTokenizer.nextToken();
                    if (bl) {
                        ++n;
                        object = trie.getAll(string3);
                        if (object != null) {
                            n3 += ((Object)object).length;
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                String string4 = Diff.apply(new StringBuffer(string3), (String)object[i]).toString();
                                if (!string4.equalsIgnoreCase(string3)) continue;
                                ++n2;
                                break;
                            }
                        } else {
                            ++n2;
                            ++n3;
                        }
                    }
                    block7: while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                        if (((String)object).equals(string3)) continue;
                        ++n;
                        String[] stringArray = trie.getAll((String)object);
                        if (stringArray != null) {
                            n3 += stringArray.length;
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string5 = Diff.apply(new StringBuffer((String)object), stringArray[i]).toString();
                                if (!string5.equalsIgnoreCase(string3)) continue;
                                ++n2;
                                continue block7;
                            }
                            continue;
                        }
                        ++n3;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                string2 = lineNumberReader.readLine();
            }
            double d = (double)n2 / (double)n;
            double d2 = (double)n2 / (double)n3;
            System.out.println("tests " + n + " succ " + n2 + " returned " + n3 + " Fmeasure " + 2.0 * d * d2 / (d + d2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

