<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="utf-8" indent="yes"/>

  <xsl:template match="/">
    <html>
      <head>
<style type="text/css">
body {background-color: #ffffee; font-family: Verdana; font-size: 10pt;}
table {display: none;}
span:hover table, span:hover table{display:inline;position:fixed;top:10px;left:70%;
background: #FFFFFF; width: 25%; padding: 5px; border: 1px dotted #808080;}
ctag {color: #C00000; display: block}
div.tekst {width: 68%;}
td {font-size: 8pt;}
tr.disamb {text-decoration: underline;}
</style>
      </head>
      <body>
        <div class="tekst">
          <xsl:apply-templates/>
        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="chunk[@type = 'p']">
    <div class="p"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="chunk[@type = 's']">
     <p>
     <xsl:apply-templates/>
     </p>
  </xsl:template>

  <xsl:template match="group">
    <xsl:call-template name="opis_grupy">
      <xsl:with-param name="miesko" select="'('"/>
      </xsl:call-template><xsl:apply-templates/><xsl:call-template name="opis_grupy">
      <xsl:with-param name="miesko" select="')'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="opis_grupy">
    <xsl:param name="synh" select="@synh"/>
    <xsl:param name="semh" select="@semh"/>
    <xsl:param name="miesko"/>
    <span><xsl:value-of select="$miesko"/><table style="color: #999;">
        <tr><td colspan="2"><strong>group</strong></td></tr>
        <tr><td><strong>type:</strong></td><td><xsl:value-of select="@type"/></td></tr>
        <tr><td><strong>synh:</strong></td><td><xsl:value-of select="//*[@id = $synh]/orth"/></td></tr>
        <tr><td><strong>semh:</strong></td><td><xsl:value-of select="//*[@id = $semh]/orth"/></td></tr>
      </table>
    </span>
  </xsl:template>

  <xsl:template match="tok">
    <span>
      <xsl:value-of select="orth"/>
      <xsl:call-template name="lex"/>
    </span>
  </xsl:template>

  <xsl:template match="syntok">
    <span>
      <xsl:value-of select="orth"/>
      <xsl:call-template name="lex"/>
    </span>
  </xsl:template>

  <xsl:template name="lex">
    <xsl:if test="lex">
      <table style="color: #999;">
        <xsl:for-each select="lex">
          <tr>
            <xsl:if test="@disamb_sh = 0">
              <xsl:attribute name="style">text-decoration: line-through;</xsl:attribute>
            </xsl:if>
            <xsl:if test="@disamb = 1">
              <xsl:attribute name="class">disamb</xsl:attribute>
            </xsl:if>
            <td><b><xsl:value-of select="base"/></b></td><td><xsl:value-of select="ctag"/></td>
          </tr>
        </xsl:for-each>
      </table>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
