/*
 * Copyright (C) 2007 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of Spejd.
 *
 * Spejd is free software: it may be distributed and/or modified under 
 * the terms of the GNU General Public License version 3 as published 
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package ipipan.spejd;

import ipipan.spejd.processing.SpejdManagingProcess;
import java.io.File;
import java.io.FileFilter;

import ipipan.spejd.readers.InputFileFilter;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.DirFileFilter;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * Main SPADE class.
 */
public class Parser {

    public FileFilter subdirs, inputFiles;
    public LinkedBlockingQueue<File> filesToBeProcessed;

    public Parser(String path, Config conf) {
        filesToBeProcessed = new LinkedBlockingQueue<File>();
        subdirs = new DirFileFilter();
        inputFiles = new InputFileFilter(conf);
        lookForFiles(new File(path));
        System.out.println("Found "+filesToBeProcessed.size()+" files.");
    }

    public void lookForFiles(File path) {
        if (!path.exists()) {
            System.out.println("\n Error: file/directory ["+path.getPath()+"] does not exists.");
            System.exit(0);
        }
        
        if (!path.isDirectory()) {
            filesToBeProcessed.add(path);
            return;
        }

        for (File f : path.listFiles(inputFiles)) {
            filesToBeProcessed.add(f);
        }

        for (File f : path.listFiles(subdirs)) {
            lookForFiles(f);
        }
    }

    /**
     * Loads rule set, parse the give directory and write a summary of
     * results.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java Parser DIR [OPTIONS]");
            System.exit(1);
        }

	// config initalisation
	// do not reinitialise - pass and / or clone instead
	Config conf = new Config("config.ini", args);
    
        Parser p = new Parser(args[0], conf);
        SpejdManagingProcess smp;
        
        smp = new SpejdManagingProcess(p.filesToBeProcessed, conf);
        smp.run();
        System.exit(0);
    }
}
