package ipipan.spejd.readers;


import java.io.PrintStream;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.util.Config;


/**
 *
 * @author axw
 */
abstract public class Reader {

    
    Config conf;

    /**
     * Get the next token from the input. 
     *
     * @return segment or no space, null if end of sentence or file
     */
    abstract public Entity loadToken();

    /**
     * Move on to the next sentence. 
     * 
     * @param out result file
     * @return true if there exists a next sentence
     */
    abstract public boolean nextSentence(PrintStream out);
    
    public abstract void close();

    
}
