/*
 * Copyright (C) 2007 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of Spejd.
 *
 * Spejd is free software: it may be distributed and/or modified under 
 * the terms of the GNU General Public License version 3 as published 
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */ 
 
 
package ipipan.spejd.readers;


import java.util.zip.GZIPInputStream;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.entities.Segment;
import ipipan.spejd.util.Config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;


public class WorkbenchReader extends Reader {
    
    BufferedReader in;
    int lineno;
    String line;
    Interpretation[] ibuf;


    public WorkbenchReader(File path, Config conf) {
	this.conf = conf;
	try {
	    InputStream s = new FileInputStream(path);
	    if(path.getName().endsWith(".gz"))
		s = new GZIPInputStream(s);
	    in = new BufferedReader(new InputStreamReader(s, conf.inputEncoding));
	} catch(IOException e) {
	    e.printStackTrace();
	}
	lineno = 0;
	nextLine();
    }

    void nextLine() {
	String s = "";
	try {
	    while((s != null) && (s.length() == 0)) {
		lineno ++;
		s = in.readLine();
	    }
	    line = s;
	} catch(IOException e) {
	    line = null;
	}
    }

    void error(String desc) {
	System.err.println("Error: " + desc);
	System.err.println("At line " + lineno);
	System.err.println(line);
	System.exit(1);
    }

    public Entity loadToken() {
	String orth, ctag, base;

	if(line.startsWith("<")) {
	    do {
		nextLine();
	    }
	    while (line != null && line.startsWith("<"));
	    return null;
	}

	String[] tabs = line.split("\t");
	if(tabs.length < 2 || tabs.length > 3)
	    error("invalid number of columns - " + tabs.length);

	nextLine();

	orth  = tabs[0];
	ctag  = tabs[1];
	base = (tabs.length == 3) ? tabs[2] : orth;
	ibuf = new Interpretation[1];
	ibuf[0] = new Interpretation(conf.tagset.cToFtag(ctag) + base, true, conf);

	return new Segment(null, orth, ibuf, conf);
    }

    /**
     * 
     * @param out
     * @return true if there exists a next sentence
     */
    public boolean nextSentence(PrintStream out) {
	while(line != null) {
	    if(!line.startsWith("<")) 
		return true;
	    out.println(line);
	    nextLine();
	}
	return false;
    }
    
    @Override
    public
    void close() {
      // TODO czy tak????
      try {
        in.close();
      } catch (IOException e) {
      }
    }

    
}
