package ipipan.spejd.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import ipipan.spejd.tagset.Tagset;


/**
 * Configuration wrapper, containing a set of variables with
 * values.
 */
public class Config {
    // configuration variables
    public Tagset tagset;
    public String rulesFile;
    public String logDir;
    public String outputFile;
    public char matchStrategy;
    public boolean nullAgreement, discardDeleted;
    public int reportInterval;
    public String inputType;
    public String inputEncoding;
    public Pattern inputFiles;    
    public String lexDictionaries;
    public String outputSuffix;
    public int maxThreads;
    public Set<String> acronymsAfter;
    public Set<String> acronymsBefore;

    public Map<String,String[]> ogonkifySubstitutions;
    public char ogonkifyStrategy;
    public int ogonkifyMinLength;
    public int ogonkifyMaxLength;

    
    public Config(String configFilename, String[] args) {
	// load configuration file
	ConfigDict config = new ConfigDict(configFilename);
	int start = 1;

	// backward compatibility check for Adam's scripts
	if(args.length >= 3 && 
	   !config.isAssignment(args[1]) &&
	   !config.isAssignment(args[2])) {
	    config.put("tagset", args[0]); 
	    config.put("rules", args[1]);
	    start = 3;
	}

	// command line arguments
	config.putAssignments(args, start, 0);

	// set the important variables
        logDir = config.getDir("logDir");
	tagset = new Tagset(config.get("tagset"));
	rulesFile = config.get("rules");
	inputType = config.get("inputType");
	inputEncoding = config.get("inputEncoding");
        inputFiles = Pattern.compile(config.get("inputFiles"));
	matchStrategy = config.getChar("matchStrategy", "*+?");
	nullAgreement = config.getBool("nullAgreement");	
	discardDeleted = config.getBool("discardDeleted");
	reportInterval = config.getInt("reportInterval");
	lexDictionaries = config.get("lexDictionaries");
	ogonkifySubstitutions = new ArrayDict(config.get("ogonkifyFile")).getDict();
	ogonkifyStrategy = config.getChar("ogonkifyStrategy", "AMN");
	ogonkifyMinLength = config.getInt("ogonkifyMinLength");
	ogonkifyMaxLength = config.getInt("ogonkifyMaxLength");
	outputSuffix = config.get("outputSuffix");
	maxThreads = config.getInt("maxThreads");
	acronymsAfter = new HashSet<String>(Arrays.asList(config.getArray("acronymsAfter", "\\|")));
	acronymsBefore = new HashSet<String>(Arrays.asList(config.getArray("acronymsBefore", "\\|")));
    }
}

